/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateLensesCopier;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateUpdateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReviewTemplateSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReviewTemplateSummary> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ReviewTemplateSummary.getter(ReviewTemplateSummary::description)).setter(ReviewTemplateSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> LENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Lenses").getter(ReviewTemplateSummary.getter(ReviewTemplateSummary::lenses)).setter(ReviewTemplateSummary.setter(Builder::lenses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lenses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(ReviewTemplateSummary.getter(ReviewTemplateSummary::owner)).setter(ReviewTemplateSummary.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ReviewTemplateSummary.getter(ReviewTemplateSummary::updatedAt)).setter(ReviewTemplateSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(ReviewTemplateSummary.getter(ReviewTemplateSummary::templateArn)).setter(ReviewTemplateSummary.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(ReviewTemplateSummary.getter(ReviewTemplateSummary::templateName)).setter(ReviewTemplateSummary.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateStatus").getter(ReviewTemplateSummary.getter(ReviewTemplateSummary::updateStatusAsString)).setter(ReviewTemplateSummary.setter(Builder::updateStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, LENSES_FIELD, OWNER_FIELD, UPDATED_AT_FIELD, TEMPLATE_ARN_FIELD, TEMPLATE_NAME_FIELD, UPDATE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReviewTemplateSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final List<String> lenses;
    private final String owner;
    private final Instant updatedAt;
    private final String templateArn;
    private final String templateName;
    private final String updateStatus;

    private ReviewTemplateSummary(BuilderImpl builder) {
        this.description = builder.description;
        this.lenses = builder.lenses;
        this.owner = builder.owner;
        this.updatedAt = builder.updatedAt;
        this.templateArn = builder.templateArn;
        this.templateName = builder.templateName;
        this.updateStatus = builder.updateStatus;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasLenses() {
        return this.lenses != null && !(this.lenses instanceof SdkAutoConstructList);
    }

    public final List<String> lenses() {
        return this.lenses;
    }

    public final String owner() {
        return this.owner;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final ReviewTemplateUpdateStatus updateStatus() {
        return ReviewTemplateUpdateStatus.fromValue(this.updateStatus);
    }

    public final String updateStatusAsString() {
        return this.updateStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLenses() ? this.lenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReviewTemplateSummary)) {
            return false;
        }
        ReviewTemplateSummary other = (ReviewTemplateSummary)obj;
        return Objects.equals(this.description(), other.description()) && this.hasLenses() == other.hasLenses() && Objects.equals(this.lenses(), other.lenses()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.updateStatusAsString(), other.updateStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReviewTemplateSummary").add("Description", (Object)this.description()).add("Lenses", this.hasLenses() ? this.lenses() : null).add("Owner", (Object)this.owner()).add("UpdatedAt", (Object)this.updatedAt()).add("TemplateArn", (Object)this.templateArn()).add("TemplateName", (Object)this.templateName()).add("UpdateStatus", (Object)this.updateStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Lenses": {
                return Optional.ofNullable(clazz.cast(this.lenses()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "UpdateStatus": {
                return Optional.ofNullable(clazz.cast(this.updateStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Lenses", LENSES_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("TemplateArn", TEMPLATE_ARN_FIELD);
        map.put("TemplateName", TEMPLATE_NAME_FIELD);
        map.put("UpdateStatus", UPDATE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReviewTemplateSummary, T> g) {
        return obj -> g.apply((ReviewTemplateSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private List<String> lenses = DefaultSdkAutoConstructList.getInstance();
        private String owner;
        private Instant updatedAt;
        private String templateArn;
        private String templateName;
        private String updateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ReviewTemplateSummary model) {
            this.description(model.description);
            this.lenses(model.lenses);
            this.owner(model.owner);
            this.updatedAt(model.updatedAt);
            this.templateArn(model.templateArn);
            this.templateName(model.templateName);
            this.updateStatus(model.updateStatus);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getLenses() {
            if (this.lenses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lenses;
        }

        public final void setLenses(Collection<String> lenses) {
            this.lenses = ReviewTemplateLensesCopier.copy(lenses);
        }

        @Override
        public final Builder lenses(Collection<String> lenses) {
            this.lenses = ReviewTemplateLensesCopier.copy(lenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(String ... lenses) {
            this.lenses(Arrays.asList(lenses));
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getUpdateStatus() {
            return this.updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(ReviewTemplateUpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        public ReviewTemplateSummary build() {
            return new ReviewTemplateSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReviewTemplateSummary> {
        public Builder description(String var1);

        public Builder lenses(Collection<String> var1);

        public Builder lenses(String ... var1);

        public Builder owner(String var1);

        public Builder updatedAt(Instant var1);

        public Builder templateArn(String var1);

        public Builder templateName(String var1);

        public Builder updateStatus(String var1);

        public Builder updateStatus(ReviewTemplateUpdateStatus var1);
    }
}

