/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ProfileNotificationSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.ProfileNotificationSummary;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProfileNotificationsResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListProfileNotificationsResponse> {
    private static final SdkField<List<ProfileNotificationSummary>> NOTIFICATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotificationSummaries").getter(ListProfileNotificationsResponse.getter(ListProfileNotificationsResponse::notificationSummaries)).setter(ListProfileNotificationsResponse.setter(Builder::notificationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileNotificationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProfileNotificationsResponse.getter(ListProfileNotificationsResponse::nextToken)).setter(ListProfileNotificationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProfileNotificationsResponse.memberNameToFieldInitializer();
    private final List<ProfileNotificationSummary> notificationSummaries;
    private final String nextToken;

    private ListProfileNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.notificationSummaries = builder.notificationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNotificationSummaries() {
        return this.notificationSummaries != null && !(this.notificationSummaries instanceof SdkAutoConstructList);
    }

    public final List<ProfileNotificationSummary> notificationSummaries() {
        return this.notificationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationSummaries() ? this.notificationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileNotificationsResponse)) {
            return false;
        }
        ListProfileNotificationsResponse other = (ListProfileNotificationsResponse)((Object)obj);
        return this.hasNotificationSummaries() == other.hasNotificationSummaries() && Objects.equals(this.notificationSummaries(), other.notificationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListProfileNotificationsResponse").add("NotificationSummaries", this.hasNotificationSummaries() ? this.notificationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotificationSummaries": {
                return Optional.ofNullable(clazz.cast(this.notificationSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NotificationSummaries", NOTIFICATION_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProfileNotificationsResponse, T> g) {
        return obj -> g.apply((ListProfileNotificationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private List<ProfileNotificationSummary> notificationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileNotificationsResponse model) {
            super(model);
            this.notificationSummaries(model.notificationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ProfileNotificationSummary.Builder> getNotificationSummaries() {
            List<ProfileNotificationSummary.Builder> result = ProfileNotificationSummariesCopier.copyToBuilder(this.notificationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationSummaries(Collection<ProfileNotificationSummary.BuilderImpl> notificationSummaries) {
            this.notificationSummaries = ProfileNotificationSummariesCopier.copyFromBuilder(notificationSummaries);
        }

        @Override
        public final Builder notificationSummaries(Collection<ProfileNotificationSummary> notificationSummaries) {
            this.notificationSummaries = ProfileNotificationSummariesCopier.copy(notificationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSummaries(ProfileNotificationSummary ... notificationSummaries) {
            this.notificationSummaries(Arrays.asList(notificationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSummaries(Consumer<ProfileNotificationSummary.Builder> ... notificationSummaries) {
            this.notificationSummaries(Stream.of(notificationSummaries).map(c -> (ProfileNotificationSummary)((ProfileNotificationSummary.Builder)ProfileNotificationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListProfileNotificationsResponse build() {
            return new ListProfileNotificationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProfileNotificationsResponse> {
        public Builder notificationSummaries(Collection<ProfileNotificationSummary> var1);

        public Builder notificationSummaries(ProfileNotificationSummary ... var1);

        public Builder notificationSummaries(Consumer<ProfileNotificationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

