/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateAnswerSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateAnswerSummary;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReviewTemplateAnswersResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListReviewTemplateAnswersResponse> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(ListReviewTemplateAnswersResponse.getter(ListReviewTemplateAnswersResponse::templateArn)).setter(ListReviewTemplateAnswersResponse.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()}).build();
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(ListReviewTemplateAnswersResponse.getter(ListReviewTemplateAnswersResponse::lensAlias)).setter(ListReviewTemplateAnswersResponse.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<List<ReviewTemplateAnswerSummary>> ANSWER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnswerSummaries").getter(ListReviewTemplateAnswersResponse.getter(ListReviewTemplateAnswersResponse::answerSummaries)).setter(ListReviewTemplateAnswersResponse.setter(Builder::answerSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnswerSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReviewTemplateAnswerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListReviewTemplateAnswersResponse.getter(ListReviewTemplateAnswersResponse::nextToken)).setter(ListReviewTemplateAnswersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD, LENS_ALIAS_FIELD, ANSWER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TemplateArn", TEMPLATE_ARN_FIELD);
            this.put("LensAlias", LENS_ALIAS_FIELD);
            this.put("AnswerSummaries", ANSWER_SUMMARIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String templateArn;
    private final String lensAlias;
    private final List<ReviewTemplateAnswerSummary> answerSummaries;
    private final String nextToken;

    private ListReviewTemplateAnswersResponse(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.lensAlias = builder.lensAlias;
        this.answerSummaries = builder.answerSummaries;
        this.nextToken = builder.nextToken;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final boolean hasAnswerSummaries() {
        return this.answerSummaries != null && !(this.answerSummaries instanceof SdkAutoConstructList);
    }

    public final List<ReviewTemplateAnswerSummary> answerSummaries() {
        return this.answerSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnswerSummaries() ? this.answerSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReviewTemplateAnswersResponse)) {
            return false;
        }
        ListReviewTemplateAnswersResponse other = (ListReviewTemplateAnswersResponse)((Object)obj);
        return Objects.equals(this.templateArn(), other.templateArn()) && Objects.equals(this.lensAlias(), other.lensAlias()) && this.hasAnswerSummaries() == other.hasAnswerSummaries() && Objects.equals(this.answerSummaries(), other.answerSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListReviewTemplateAnswersResponse").add("TemplateArn", (Object)this.templateArn()).add("LensAlias", (Object)this.lensAlias()).add("AnswerSummaries", this.hasAnswerSummaries() ? this.answerSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "AnswerSummaries": {
                return Optional.ofNullable(clazz.cast(this.answerSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListReviewTemplateAnswersResponse, T> g) {
        return obj -> g.apply((ListReviewTemplateAnswersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String templateArn;
        private String lensAlias;
        private List<ReviewTemplateAnswerSummary> answerSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReviewTemplateAnswersResponse model) {
            super(model);
            this.templateArn(model.templateArn);
            this.lensAlias(model.lensAlias);
            this.answerSummaries(model.answerSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final List<ReviewTemplateAnswerSummary.Builder> getAnswerSummaries() {
            List<ReviewTemplateAnswerSummary.Builder> result = ReviewTemplateAnswerSummariesCopier.copyToBuilder(this.answerSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnswerSummaries(Collection<ReviewTemplateAnswerSummary.BuilderImpl> answerSummaries) {
            this.answerSummaries = ReviewTemplateAnswerSummariesCopier.copyFromBuilder(answerSummaries);
        }

        @Override
        public final Builder answerSummaries(Collection<ReviewTemplateAnswerSummary> answerSummaries) {
            this.answerSummaries = ReviewTemplateAnswerSummariesCopier.copy(answerSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answerSummaries(ReviewTemplateAnswerSummary ... answerSummaries) {
            this.answerSummaries(Arrays.asList(answerSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder answerSummaries(Consumer<ReviewTemplateAnswerSummary.Builder> ... answerSummaries) {
            this.answerSummaries(Stream.of(answerSummaries).map(c -> (ReviewTemplateAnswerSummary)((ReviewTemplateAnswerSummary.Builder)ReviewTemplateAnswerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReviewTemplateAnswersResponse build() {
            return new ListReviewTemplateAnswersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReviewTemplateAnswersResponse> {
        public Builder templateArn(String var1);

        public Builder lensAlias(String var1);

        public Builder answerSummaries(Collection<ReviewTemplateAnswerSummary> var1);

        public Builder answerSummaries(ReviewTemplateAnswerSummary ... var1);

        public Builder answerSummaries(Consumer<ReviewTemplateAnswerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

