/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LensUpgradeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LensUpgradeSummary> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(LensUpgradeSummary.getter(LensUpgradeSummary::workloadId)).setter(LensUpgradeSummary.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(LensUpgradeSummary.getter(LensUpgradeSummary::workloadName)).setter(LensUpgradeSummary.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(LensUpgradeSummary.getter(LensUpgradeSummary::lensAlias)).setter(LensUpgradeSummary.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensArn").getter(LensUpgradeSummary.getter(LensUpgradeSummary::lensArn)).setter(LensUpgradeSummary.setter(Builder::lensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()}).build();
    private static final SdkField<String> CURRENT_LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentLensVersion").getter(LensUpgradeSummary.getter(LensUpgradeSummary::currentLensVersion)).setter(LensUpgradeSummary.setter(Builder::currentLensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentLensVersion").build()}).build();
    private static final SdkField<String> LATEST_LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestLensVersion").getter(LensUpgradeSummary.getter(LensUpgradeSummary::latestLensVersion)).setter(LensUpgradeSummary.setter(Builder::latestLensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestLensVersion").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(LensUpgradeSummary.getter(LensUpgradeSummary::resourceArn)).setter(LensUpgradeSummary.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(LensUpgradeSummary.getter(LensUpgradeSummary::resourceName)).setter(LensUpgradeSummary.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, WORKLOAD_NAME_FIELD, LENS_ALIAS_FIELD, LENS_ARN_FIELD, CURRENT_LENS_VERSION_FIELD, LATEST_LENS_VERSION_FIELD, RESOURCE_ARN_FIELD, RESOURCE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WorkloadId", WORKLOAD_ID_FIELD);
            this.put("WorkloadName", WORKLOAD_NAME_FIELD);
            this.put("LensAlias", LENS_ALIAS_FIELD);
            this.put("LensArn", LENS_ARN_FIELD);
            this.put("CurrentLensVersion", CURRENT_LENS_VERSION_FIELD);
            this.put("LatestLensVersion", LATEST_LENS_VERSION_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("ResourceName", RESOURCE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String workloadId;
    private final String workloadName;
    private final String lensAlias;
    private final String lensArn;
    private final String currentLensVersion;
    private final String latestLensVersion;
    private final String resourceArn;
    private final String resourceName;

    private LensUpgradeSummary(BuilderImpl builder) {
        this.workloadId = builder.workloadId;
        this.workloadName = builder.workloadName;
        this.lensAlias = builder.lensAlias;
        this.lensArn = builder.lensArn;
        this.currentLensVersion = builder.currentLensVersion;
        this.latestLensVersion = builder.latestLensVersion;
        this.resourceArn = builder.resourceArn;
        this.resourceName = builder.resourceName;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String lensArn() {
        return this.lensArn;
    }

    public final String currentLensVersion() {
        return this.currentLensVersion;
    }

    public final String latestLensVersion() {
        return this.latestLensVersion;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensUpgradeSummary)) {
            return false;
        }
        LensUpgradeSummary other = (LensUpgradeSummary)obj;
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.lensArn(), other.lensArn()) && Objects.equals(this.currentLensVersion(), other.currentLensVersion()) && Objects.equals(this.latestLensVersion(), other.latestLensVersion()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceName(), other.resourceName());
    }

    public final String toString() {
        return ToString.builder((String)"LensUpgradeSummary").add("WorkloadId", (Object)this.workloadId()).add("WorkloadName", (Object)this.workloadName()).add("LensAlias", (Object)this.lensAlias()).add("LensArn", (Object)this.lensArn()).add("CurrentLensVersion", (Object)this.currentLensVersion()).add("LatestLensVersion", (Object)this.latestLensVersion()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceName", (Object)this.resourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "LensArn": {
                return Optional.ofNullable(clazz.cast(this.lensArn()));
            }
            case "CurrentLensVersion": {
                return Optional.ofNullable(clazz.cast(this.currentLensVersion()));
            }
            case "LatestLensVersion": {
                return Optional.ofNullable(clazz.cast(this.latestLensVersion()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LensUpgradeSummary, T> g) {
        return obj -> g.apply((LensUpgradeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workloadId;
        private String workloadName;
        private String lensAlias;
        private String lensArn;
        private String currentLensVersion;
        private String latestLensVersion;
        private String resourceArn;
        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(LensUpgradeSummary model) {
            this.workloadId(model.workloadId);
            this.workloadName(model.workloadName);
            this.lensAlias(model.lensAlias);
            this.lensArn(model.lensArn);
            this.currentLensVersion(model.currentLensVersion);
            this.latestLensVersion(model.latestLensVersion);
            this.resourceArn(model.resourceArn);
            this.resourceName(model.resourceName);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensArn() {
            return this.lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getCurrentLensVersion() {
            return this.currentLensVersion;
        }

        public final void setCurrentLensVersion(String currentLensVersion) {
            this.currentLensVersion = currentLensVersion;
        }

        @Override
        public final Builder currentLensVersion(String currentLensVersion) {
            this.currentLensVersion = currentLensVersion;
            return this;
        }

        public final String getLatestLensVersion() {
            return this.latestLensVersion;
        }

        public final void setLatestLensVersion(String latestLensVersion) {
            this.latestLensVersion = latestLensVersion;
        }

        @Override
        public final Builder latestLensVersion(String latestLensVersion) {
            this.latestLensVersion = latestLensVersion;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public LensUpgradeSummary build() {
            return new LensUpgradeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LensUpgradeSummary> {
        public Builder workloadId(String var1);

        public Builder workloadName(String var1);

        public Builder lensAlias(String var1);

        public Builder lensArn(String var1);

        public Builder currentLensVersion(String var1);

        public Builder latestLensVersion(String var1);

        public Builder resourceArn(String var1);

        public Builder resourceName(String var1);
    }
}

