/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ProfileQuestionUpdate;
import software.amazon.awssdk.services.wellarchitected.model.ProfileQuestionUpdatesCopier;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProfileRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, UpdateProfileRequest> {
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileArn").getter(UpdateProfileRequest.getter(UpdateProfileRequest::profileArn)).setter(UpdateProfileRequest.setter(Builder::profileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ProfileArn").build()}).build();
    private static final SdkField<String> PROFILE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileDescription").getter(UpdateProfileRequest.getter(UpdateProfileRequest::profileDescription)).setter(UpdateProfileRequest.setter(Builder::profileDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileDescription").build()}).build();
    private static final SdkField<List<ProfileQuestionUpdate>> PROFILE_QUESTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileQuestions").getter(UpdateProfileRequest.getter(UpdateProfileRequest::profileQuestions)).setter(UpdateProfileRequest.setter(Builder::profileQuestions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileQuestions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileQuestionUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ARN_FIELD, PROFILE_DESCRIPTION_FIELD, PROFILE_QUESTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProfileArn", PROFILE_ARN_FIELD);
            this.put("ProfileDescription", PROFILE_DESCRIPTION_FIELD);
            this.put("ProfileQuestions", PROFILE_QUESTIONS_FIELD);
        }
    });
    private final String profileArn;
    private final String profileDescription;
    private final List<ProfileQuestionUpdate> profileQuestions;

    private UpdateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileArn = builder.profileArn;
        this.profileDescription = builder.profileDescription;
        this.profileQuestions = builder.profileQuestions;
    }

    public final String profileArn() {
        return this.profileArn;
    }

    public final String profileDescription() {
        return this.profileDescription;
    }

    public final boolean hasProfileQuestions() {
        return this.profileQuestions != null && !(this.profileQuestions instanceof SdkAutoConstructList);
    }

    public final List<ProfileQuestionUpdate> profileQuestions() {
        return this.profileQuestions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileQuestions() ? this.profileQuestions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfileRequest)) {
            return false;
        }
        UpdateProfileRequest other = (UpdateProfileRequest)((Object)obj);
        return Objects.equals(this.profileArn(), other.profileArn()) && Objects.equals(this.profileDescription(), other.profileDescription()) && this.hasProfileQuestions() == other.hasProfileQuestions() && Objects.equals(this.profileQuestions(), other.profileQuestions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProfileRequest").add("ProfileArn", (Object)this.profileArn()).add("ProfileDescription", (Object)this.profileDescription()).add("ProfileQuestions", this.hasProfileQuestions() ? this.profileQuestions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
            case "ProfileDescription": {
                return Optional.ofNullable(clazz.cast(this.profileDescription()));
            }
            case "ProfileQuestions": {
                return Optional.ofNullable(clazz.cast(this.profileQuestions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfileRequest, T> g) {
        return obj -> g.apply((UpdateProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String profileArn;
        private String profileDescription;
        private List<ProfileQuestionUpdate> profileQuestions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfileRequest model) {
            super(model);
            this.profileArn(model.profileArn);
            this.profileDescription(model.profileDescription);
            this.profileQuestions(model.profileQuestions);
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getProfileDescription() {
            return this.profileDescription;
        }

        public final void setProfileDescription(String profileDescription) {
            this.profileDescription = profileDescription;
        }

        @Override
        public final Builder profileDescription(String profileDescription) {
            this.profileDescription = profileDescription;
            return this;
        }

        public final List<ProfileQuestionUpdate.Builder> getProfileQuestions() {
            List<ProfileQuestionUpdate.Builder> result = ProfileQuestionUpdatesCopier.copyToBuilder(this.profileQuestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfileQuestions(Collection<ProfileQuestionUpdate.BuilderImpl> profileQuestions) {
            this.profileQuestions = ProfileQuestionUpdatesCopier.copyFromBuilder(profileQuestions);
        }

        @Override
        public final Builder profileQuestions(Collection<ProfileQuestionUpdate> profileQuestions) {
            this.profileQuestions = ProfileQuestionUpdatesCopier.copy(profileQuestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileQuestions(ProfileQuestionUpdate ... profileQuestions) {
            this.profileQuestions(Arrays.asList(profileQuestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileQuestions(Consumer<ProfileQuestionUpdate.Builder> ... profileQuestions) {
            this.profileQuestions(Stream.of(profileQuestions).map(c -> (ProfileQuestionUpdate)((ProfileQuestionUpdate.Builder)ProfileQuestionUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProfileRequest build() {
            return new UpdateProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProfileRequest> {
        public Builder profileArn(String var1);

        public Builder profileDescription(String var1);

        public Builder profileQuestions(Collection<ProfileQuestionUpdate> var1);

        public Builder profileQuestions(ProfileQuestionUpdate ... var1);

        public Builder profileQuestions(Consumer<ProfileQuestionUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

