/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListNotificationsResponse;

public class ListNotificationsPublisher
implements SdkPublisher<ListNotificationsResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListNotificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNotificationsPublisher(WellArchitectedAsyncClient client, ListNotificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNotificationsPublisher(WellArchitectedAsyncClient client, ListNotificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNotificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNotificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListNotificationsResponseFetcher
    implements AsyncPageFetcher<ListNotificationsResponse> {
        private ListNotificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListNotificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNotificationsResponse> nextPage(ListNotificationsResponse previousPage) {
            if (previousPage == null) {
                return ListNotificationsPublisher.this.client.listNotifications(ListNotificationsPublisher.this.firstRequest);
            }
            return ListNotificationsPublisher.this.client.listNotifications((ListNotificationsRequest)((Object)ListNotificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

