/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProfileRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, GetProfileRequest> {
    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileArn").getter(GetProfileRequest.getter(GetProfileRequest::profileArn)).setter(GetProfileRequest.setter(Builder::profileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ProfileArn").build()}).build();
    private static final SdkField<String> PROFILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileVersion").getter(GetProfileRequest.getter(GetProfileRequest::profileVersion)).setter(GetProfileRequest.setter(Builder::profileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProfileVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ARN_FIELD, PROFILE_VERSION_FIELD));
    private final String profileArn;
    private final String profileVersion;

    private GetProfileRequest(BuilderImpl builder) {
        super(builder);
        this.profileArn = builder.profileArn;
        this.profileVersion = builder.profileVersion;
    }

    public final String profileArn() {
        return this.profileArn;
    }

    public final String profileVersion() {
        return this.profileVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileRequest)) {
            return false;
        }
        GetProfileRequest other = (GetProfileRequest)((Object)obj);
        return Objects.equals(this.profileArn(), other.profileArn()) && Objects.equals(this.profileVersion(), other.profileVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetProfileRequest").add("ProfileArn", (Object)this.profileArn()).add("ProfileVersion", (Object)this.profileVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileArn": {
                return Optional.ofNullable(clazz.cast(this.profileArn()));
            }
            case "ProfileVersion": {
                return Optional.ofNullable(clazz.cast(this.profileVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProfileRequest, T> g) {
        return obj -> g.apply((GetProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String profileArn;
        private String profileVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileRequest model) {
            super(model);
            this.profileArn(model.profileArn);
            this.profileVersion(model.profileVersion);
        }

        public final String getProfileArn() {
            return this.profileArn;
        }

        public final void setProfileArn(String profileArn) {
            this.profileArn = profileArn;
        }

        @Override
        public final Builder profileArn(String profileArn) {
            this.profileArn = profileArn;
            return this;
        }

        public final String getProfileVersion() {
            return this.profileVersion;
        }

        public final void setProfileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
        }

        @Override
        public final Builder profileVersion(String profileVersion) {
            this.profileVersion = profileVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProfileRequest build() {
            return new GetProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProfileRequest> {
        public Builder profileArn(String var1);

        public Builder profileVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

