/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.ReviewTemplateArnsCopier;
import software.amazon.awssdk.services.wellarchitected.model.TagMapCopier;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadAccountIdsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadApplicationsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadAwsRegionsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadDiscoveryConfig;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadEnvironment;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadLensesCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadNonAwsRegionsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadPillarPrioritiesCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadProfileArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkloadRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, CreateWorkloadRequest> {
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::workloadName)).setter(CreateWorkloadRequest.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::description)).setter(CreateWorkloadRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Environment").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::environmentAsString)).setter(CreateWorkloadRequest.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIds").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::accountIds)).setter(CreateWorkloadRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AwsRegions").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::awsRegions)).setter(CreateWorkloadRequest.setter(Builder::awsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NON_AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NonAwsRegions").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::nonAwsRegions)).setter(CreateWorkloadRequest.setter(Builder::nonAwsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonAwsRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PILLAR_PRIORITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PillarPriorities").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::pillarPriorities)).setter(CreateWorkloadRequest.setter(Builder::pillarPriorities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarPriorities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARCHITECTURAL_DESIGN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArchitecturalDesign").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::architecturalDesign)).setter(CreateWorkloadRequest.setter(Builder::architecturalDesign)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchitecturalDesign").build()}).build();
    private static final SdkField<String> REVIEW_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReviewOwner").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::reviewOwner)).setter(CreateWorkloadRequest.setter(Builder::reviewOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewOwner").build()}).build();
    private static final SdkField<String> INDUSTRY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndustryType").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::industryType)).setter(CreateWorkloadRequest.setter(Builder::industryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndustryType").build()}).build();
    private static final SdkField<String> INDUSTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Industry").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::industry)).setter(CreateWorkloadRequest.setter(Builder::industry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()}).build();
    private static final SdkField<List<String>> LENSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Lenses").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::lenses)).setter(CreateWorkloadRequest.setter(Builder::lenses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lenses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::notes)).setter(CreateWorkloadRequest.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::clientRequestToken)).setter(CreateWorkloadRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::tags)).setter(CreateWorkloadRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<WorkloadDiscoveryConfig> DISCOVERY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DiscoveryConfig").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::discoveryConfig)).setter(CreateWorkloadRequest.setter(Builder::discoveryConfig)).constructor(WorkloadDiscoveryConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryConfig").build()}).build();
    private static final SdkField<List<String>> APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Applications").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::applications)).setter(CreateWorkloadRequest.setter(Builder::applications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Applications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROFILE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileArns").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::profileArns)).setter(CreateWorkloadRequest.setter(Builder::profileArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REVIEW_TEMPLATE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReviewTemplateArns").getter(CreateWorkloadRequest.getter(CreateWorkloadRequest::reviewTemplateArns)).setter(CreateWorkloadRequest.setter(Builder::reviewTemplateArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewTemplateArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_NAME_FIELD, DESCRIPTION_FIELD, ENVIRONMENT_FIELD, ACCOUNT_IDS_FIELD, AWS_REGIONS_FIELD, NON_AWS_REGIONS_FIELD, PILLAR_PRIORITIES_FIELD, ARCHITECTURAL_DESIGN_FIELD, REVIEW_OWNER_FIELD, INDUSTRY_TYPE_FIELD, INDUSTRY_FIELD, LENSES_FIELD, NOTES_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, DISCOVERY_CONFIG_FIELD, APPLICATIONS_FIELD, PROFILE_ARNS_FIELD, REVIEW_TEMPLATE_ARNS_FIELD));
    private final String workloadName;
    private final String description;
    private final String environment;
    private final List<String> accountIds;
    private final List<String> awsRegions;
    private final List<String> nonAwsRegions;
    private final List<String> pillarPriorities;
    private final String architecturalDesign;
    private final String reviewOwner;
    private final String industryType;
    private final String industry;
    private final List<String> lenses;
    private final String notes;
    private final String clientRequestToken;
    private final Map<String, String> tags;
    private final WorkloadDiscoveryConfig discoveryConfig;
    private final List<String> applications;
    private final List<String> profileArns;
    private final List<String> reviewTemplateArns;

    private CreateWorkloadRequest(BuilderImpl builder) {
        super(builder);
        this.workloadName = builder.workloadName;
        this.description = builder.description;
        this.environment = builder.environment;
        this.accountIds = builder.accountIds;
        this.awsRegions = builder.awsRegions;
        this.nonAwsRegions = builder.nonAwsRegions;
        this.pillarPriorities = builder.pillarPriorities;
        this.architecturalDesign = builder.architecturalDesign;
        this.reviewOwner = builder.reviewOwner;
        this.industryType = builder.industryType;
        this.industry = builder.industry;
        this.lenses = builder.lenses;
        this.notes = builder.notes;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.discoveryConfig = builder.discoveryConfig;
        this.applications = builder.applications;
        this.profileArns = builder.profileArns;
        this.reviewTemplateArns = builder.reviewTemplateArns;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public final String description() {
        return this.description;
    }

    public final WorkloadEnvironment environment() {
        return WorkloadEnvironment.fromValue(this.environment);
    }

    public final String environmentAsString() {
        return this.environment;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final boolean hasAwsRegions() {
        return this.awsRegions != null && !(this.awsRegions instanceof SdkAutoConstructList);
    }

    public final List<String> awsRegions() {
        return this.awsRegions;
    }

    public final boolean hasNonAwsRegions() {
        return this.nonAwsRegions != null && !(this.nonAwsRegions instanceof SdkAutoConstructList);
    }

    public final List<String> nonAwsRegions() {
        return this.nonAwsRegions;
    }

    public final boolean hasPillarPriorities() {
        return this.pillarPriorities != null && !(this.pillarPriorities instanceof SdkAutoConstructList);
    }

    public final List<String> pillarPriorities() {
        return this.pillarPriorities;
    }

    public final String architecturalDesign() {
        return this.architecturalDesign;
    }

    public final String reviewOwner() {
        return this.reviewOwner;
    }

    public final String industryType() {
        return this.industryType;
    }

    public final String industry() {
        return this.industry;
    }

    public final boolean hasLenses() {
        return this.lenses != null && !(this.lenses instanceof SdkAutoConstructList);
    }

    public final List<String> lenses() {
        return this.lenses;
    }

    public final String notes() {
        return this.notes;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final WorkloadDiscoveryConfig discoveryConfig() {
        return this.discoveryConfig;
    }

    public final boolean hasApplications() {
        return this.applications != null && !(this.applications instanceof SdkAutoConstructList);
    }

    public final List<String> applications() {
        return this.applications;
    }

    public final boolean hasProfileArns() {
        return this.profileArns != null && !(this.profileArns instanceof SdkAutoConstructList);
    }

    public final List<String> profileArns() {
        return this.profileArns;
    }

    public final boolean hasReviewTemplateArns() {
        return this.reviewTemplateArns != null && !(this.reviewTemplateArns instanceof SdkAutoConstructList);
    }

    public final List<String> reviewTemplateArns() {
        return this.reviewTemplateArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAwsRegions() ? this.awsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNonAwsRegions() ? this.nonAwsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPillarPriorities() ? this.pillarPriorities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.architecturalDesign());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.industryType());
        hashCode = 31 * hashCode + Objects.hashCode(this.industry());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLenses() ? this.lenses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplications() ? this.applications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileArns() ? this.profileArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReviewTemplateArns() ? this.reviewTemplateArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkloadRequest)) {
            return false;
        }
        CreateWorkloadRequest other = (CreateWorkloadRequest)((Object)obj);
        return Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.environmentAsString(), other.environmentAsString()) && this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasAwsRegions() == other.hasAwsRegions() && Objects.equals(this.awsRegions(), other.awsRegions()) && this.hasNonAwsRegions() == other.hasNonAwsRegions() && Objects.equals(this.nonAwsRegions(), other.nonAwsRegions()) && this.hasPillarPriorities() == other.hasPillarPriorities() && Objects.equals(this.pillarPriorities(), other.pillarPriorities()) && Objects.equals(this.architecturalDesign(), other.architecturalDesign()) && Objects.equals(this.reviewOwner(), other.reviewOwner()) && Objects.equals(this.industryType(), other.industryType()) && Objects.equals(this.industry(), other.industry()) && this.hasLenses() == other.hasLenses() && Objects.equals(this.lenses(), other.lenses()) && Objects.equals(this.notes(), other.notes()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.discoveryConfig(), other.discoveryConfig()) && this.hasApplications() == other.hasApplications() && Objects.equals(this.applications(), other.applications()) && this.hasProfileArns() == other.hasProfileArns() && Objects.equals(this.profileArns(), other.profileArns()) && this.hasReviewTemplateArns() == other.hasReviewTemplateArns() && Objects.equals(this.reviewTemplateArns(), other.reviewTemplateArns());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkloadRequest").add("WorkloadName", (Object)this.workloadName()).add("Description", (Object)this.description()).add("Environment", (Object)this.environmentAsString()).add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("AwsRegions", this.hasAwsRegions() ? this.awsRegions() : null).add("NonAwsRegions", this.hasNonAwsRegions() ? this.nonAwsRegions() : null).add("PillarPriorities", this.hasPillarPriorities() ? this.pillarPriorities() : null).add("ArchitecturalDesign", (Object)this.architecturalDesign()).add("ReviewOwner", (Object)this.reviewOwner()).add("IndustryType", (Object)this.industryType()).add("Industry", (Object)this.industry()).add("Lenses", this.hasLenses() ? this.lenses() : null).add("Notes", (Object)this.notes()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).add("DiscoveryConfig", (Object)this.discoveryConfig()).add("Applications", this.hasApplications() ? this.applications() : null).add("ProfileArns", this.hasProfileArns() ? this.profileArns() : null).add("ReviewTemplateArns", this.hasReviewTemplateArns() ? this.reviewTemplateArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environmentAsString()));
            }
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "AwsRegions": {
                return Optional.ofNullable(clazz.cast(this.awsRegions()));
            }
            case "NonAwsRegions": {
                return Optional.ofNullable(clazz.cast(this.nonAwsRegions()));
            }
            case "PillarPriorities": {
                return Optional.ofNullable(clazz.cast(this.pillarPriorities()));
            }
            case "ArchitecturalDesign": {
                return Optional.ofNullable(clazz.cast(this.architecturalDesign()));
            }
            case "ReviewOwner": {
                return Optional.ofNullable(clazz.cast(this.reviewOwner()));
            }
            case "IndustryType": {
                return Optional.ofNullable(clazz.cast(this.industryType()));
            }
            case "Industry": {
                return Optional.ofNullable(clazz.cast(this.industry()));
            }
            case "Lenses": {
                return Optional.ofNullable(clazz.cast(this.lenses()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DiscoveryConfig": {
                return Optional.ofNullable(clazz.cast(this.discoveryConfig()));
            }
            case "Applications": {
                return Optional.ofNullable(clazz.cast(this.applications()));
            }
            case "ProfileArns": {
                return Optional.ofNullable(clazz.cast(this.profileArns()));
            }
            case "ReviewTemplateArns": {
                return Optional.ofNullable(clazz.cast(this.reviewTemplateArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkloadRequest, T> g) {
        return obj -> g.apply((CreateWorkloadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String workloadName;
        private String description;
        private String environment;
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> awsRegions = DefaultSdkAutoConstructList.getInstance();
        private List<String> nonAwsRegions = DefaultSdkAutoConstructList.getInstance();
        private List<String> pillarPriorities = DefaultSdkAutoConstructList.getInstance();
        private String architecturalDesign;
        private String reviewOwner;
        private String industryType;
        private String industry;
        private List<String> lenses = DefaultSdkAutoConstructList.getInstance();
        private String notes;
        private String clientRequestToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private WorkloadDiscoveryConfig discoveryConfig;
        private List<String> applications = DefaultSdkAutoConstructList.getInstance();
        private List<String> profileArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> reviewTemplateArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkloadRequest model) {
            super(model);
            this.workloadName(model.workloadName);
            this.description(model.description);
            this.environment(model.environment);
            this.accountIds(model.accountIds);
            this.awsRegions(model.awsRegions);
            this.nonAwsRegions(model.nonAwsRegions);
            this.pillarPriorities(model.pillarPriorities);
            this.architecturalDesign(model.architecturalDesign);
            this.reviewOwner(model.reviewOwner);
            this.industryType(model.industryType);
            this.industry(model.industry);
            this.lenses(model.lenses);
            this.notes(model.notes);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
            this.discoveryConfig(model.discoveryConfig);
            this.applications(model.applications);
            this.profileArns(model.profileArns);
            this.reviewTemplateArns(model.reviewTemplateArns);
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEnvironment() {
            return this.environment;
        }

        public final void setEnvironment(String environment) {
            this.environment = environment;
        }

        @Override
        public final Builder environment(String environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public final Builder environment(WorkloadEnvironment environment) {
            this.environment(environment == null ? null : environment.toString());
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = WorkloadAccountIdsCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = WorkloadAccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getAwsRegions() {
            if (this.awsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.awsRegions;
        }

        public final void setAwsRegions(Collection<String> awsRegions) {
            this.awsRegions = WorkloadAwsRegionsCopier.copy(awsRegions);
        }

        @Override
        public final Builder awsRegions(Collection<String> awsRegions) {
            this.awsRegions = WorkloadAwsRegionsCopier.copy(awsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsRegions(String ... awsRegions) {
            this.awsRegions(Arrays.asList(awsRegions));
            return this;
        }

        public final Collection<String> getNonAwsRegions() {
            if (this.nonAwsRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nonAwsRegions;
        }

        public final void setNonAwsRegions(Collection<String> nonAwsRegions) {
            this.nonAwsRegions = WorkloadNonAwsRegionsCopier.copy(nonAwsRegions);
        }

        @Override
        public final Builder nonAwsRegions(Collection<String> nonAwsRegions) {
            this.nonAwsRegions = WorkloadNonAwsRegionsCopier.copy(nonAwsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonAwsRegions(String ... nonAwsRegions) {
            this.nonAwsRegions(Arrays.asList(nonAwsRegions));
            return this;
        }

        public final Collection<String> getPillarPriorities() {
            if (this.pillarPriorities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pillarPriorities;
        }

        public final void setPillarPriorities(Collection<String> pillarPriorities) {
            this.pillarPriorities = WorkloadPillarPrioritiesCopier.copy(pillarPriorities);
        }

        @Override
        public final Builder pillarPriorities(Collection<String> pillarPriorities) {
            this.pillarPriorities = WorkloadPillarPrioritiesCopier.copy(pillarPriorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarPriorities(String ... pillarPriorities) {
            this.pillarPriorities(Arrays.asList(pillarPriorities));
            return this;
        }

        public final String getArchitecturalDesign() {
            return this.architecturalDesign;
        }

        public final void setArchitecturalDesign(String architecturalDesign) {
            this.architecturalDesign = architecturalDesign;
        }

        @Override
        public final Builder architecturalDesign(String architecturalDesign) {
            this.architecturalDesign = architecturalDesign;
            return this;
        }

        public final String getReviewOwner() {
            return this.reviewOwner;
        }

        public final void setReviewOwner(String reviewOwner) {
            this.reviewOwner = reviewOwner;
        }

        @Override
        public final Builder reviewOwner(String reviewOwner) {
            this.reviewOwner = reviewOwner;
            return this;
        }

        public final String getIndustryType() {
            return this.industryType;
        }

        public final void setIndustryType(String industryType) {
            this.industryType = industryType;
        }

        @Override
        public final Builder industryType(String industryType) {
            this.industryType = industryType;
            return this;
        }

        public final String getIndustry() {
            return this.industry;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        @Override
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        public final Collection<String> getLenses() {
            if (this.lenses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lenses;
        }

        public final void setLenses(Collection<String> lenses) {
            this.lenses = WorkloadLensesCopier.copy(lenses);
        }

        @Override
        public final Builder lenses(Collection<String> lenses) {
            this.lenses = WorkloadLensesCopier.copy(lenses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lenses(String ... lenses) {
            this.lenses(Arrays.asList(lenses));
            return this;
        }

        public final String getNotes() {
            return this.notes;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final WorkloadDiscoveryConfig.Builder getDiscoveryConfig() {
            return this.discoveryConfig != null ? this.discoveryConfig.toBuilder() : null;
        }

        public final void setDiscoveryConfig(WorkloadDiscoveryConfig.BuilderImpl discoveryConfig) {
            this.discoveryConfig = discoveryConfig != null ? discoveryConfig.build() : null;
        }

        @Override
        public final Builder discoveryConfig(WorkloadDiscoveryConfig discoveryConfig) {
            this.discoveryConfig = discoveryConfig;
            return this;
        }

        public final Collection<String> getApplications() {
            if (this.applications instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applications;
        }

        public final void setApplications(Collection<String> applications) {
            this.applications = WorkloadApplicationsCopier.copy(applications);
        }

        @Override
        public final Builder applications(Collection<String> applications) {
            this.applications = WorkloadApplicationsCopier.copy(applications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applications(String ... applications) {
            this.applications(Arrays.asList(applications));
            return this;
        }

        public final Collection<String> getProfileArns() {
            if (this.profileArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.profileArns;
        }

        public final void setProfileArns(Collection<String> profileArns) {
            this.profileArns = WorkloadProfileArnsCopier.copy(profileArns);
        }

        @Override
        public final Builder profileArns(Collection<String> profileArns) {
            this.profileArns = WorkloadProfileArnsCopier.copy(profileArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileArns(String ... profileArns) {
            this.profileArns(Arrays.asList(profileArns));
            return this;
        }

        public final Collection<String> getReviewTemplateArns() {
            if (this.reviewTemplateArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reviewTemplateArns;
        }

        public final void setReviewTemplateArns(Collection<String> reviewTemplateArns) {
            this.reviewTemplateArns = ReviewTemplateArnsCopier.copy(reviewTemplateArns);
        }

        @Override
        public final Builder reviewTemplateArns(Collection<String> reviewTemplateArns) {
            this.reviewTemplateArns = ReviewTemplateArnsCopier.copy(reviewTemplateArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewTemplateArns(String ... reviewTemplateArns) {
            this.reviewTemplateArns(Arrays.asList(reviewTemplateArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkloadRequest build() {
            return new CreateWorkloadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkloadRequest> {
        public Builder workloadName(String var1);

        public Builder description(String var1);

        public Builder environment(String var1);

        public Builder environment(WorkloadEnvironment var1);

        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder awsRegions(Collection<String> var1);

        public Builder awsRegions(String ... var1);

        public Builder nonAwsRegions(Collection<String> var1);

        public Builder nonAwsRegions(String ... var1);

        public Builder pillarPriorities(Collection<String> var1);

        public Builder pillarPriorities(String ... var1);

        public Builder architecturalDesign(String var1);

        public Builder reviewOwner(String var1);

        public Builder industryType(String var1);

        public Builder industry(String var1);

        public Builder lenses(Collection<String> var1);

        public Builder lenses(String ... var1);

        public Builder notes(String var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder discoveryConfig(WorkloadDiscoveryConfig var1);

        default public Builder discoveryConfig(Consumer<WorkloadDiscoveryConfig.Builder> discoveryConfig) {
            return this.discoveryConfig((WorkloadDiscoveryConfig)((WorkloadDiscoveryConfig.Builder)WorkloadDiscoveryConfig.builder().applyMutation(discoveryConfig)).build());
        }

        public Builder applications(Collection<String> var1);

        public Builder applications(String ... var1);

        public Builder profileArns(Collection<String> var1);

        public Builder profileArns(String ... var1);

        public Builder reviewTemplateArns(Collection<String> var1);

        public Builder reviewTemplateArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

