/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.TemplateShareSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.TemplateShareSummary;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTemplateSharesResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListTemplateSharesResponse> {
    private static final SdkField<String> TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateArn").getter(ListTemplateSharesResponse.getter(ListTemplateSharesResponse::templateArn)).setter(ListTemplateSharesResponse.setter(Builder::templateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateArn").build()}).build();
    private static final SdkField<List<TemplateShareSummary>> TEMPLATE_SHARE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TemplateShareSummaries").getter(ListTemplateSharesResponse.getter(ListTemplateSharesResponse::templateShareSummaries)).setter(ListTemplateSharesResponse.setter(Builder::templateShareSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateShareSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TemplateShareSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTemplateSharesResponse.getter(ListTemplateSharesResponse::nextToken)).setter(ListTemplateSharesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ARN_FIELD, TEMPLATE_SHARE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final String templateArn;
    private final List<TemplateShareSummary> templateShareSummaries;
    private final String nextToken;

    private ListTemplateSharesResponse(BuilderImpl builder) {
        super(builder);
        this.templateArn = builder.templateArn;
        this.templateShareSummaries = builder.templateShareSummaries;
        this.nextToken = builder.nextToken;
    }

    public final String templateArn() {
        return this.templateArn;
    }

    public final boolean hasTemplateShareSummaries() {
        return this.templateShareSummaries != null && !(this.templateShareSummaries instanceof SdkAutoConstructList);
    }

    public final List<TemplateShareSummary> templateShareSummaries() {
        return this.templateShareSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateShareSummaries() ? this.templateShareSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplateSharesResponse)) {
            return false;
        }
        ListTemplateSharesResponse other = (ListTemplateSharesResponse)((Object)obj);
        return Objects.equals(this.templateArn(), other.templateArn()) && this.hasTemplateShareSummaries() == other.hasTemplateShareSummaries() && Objects.equals(this.templateShareSummaries(), other.templateShareSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTemplateSharesResponse").add("TemplateArn", (Object)this.templateArn()).add("TemplateShareSummaries", this.hasTemplateShareSummaries() ? this.templateShareSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateArn": {
                return Optional.ofNullable(clazz.cast(this.templateArn()));
            }
            case "TemplateShareSummaries": {
                return Optional.ofNullable(clazz.cast(this.templateShareSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTemplateSharesResponse, T> g) {
        return obj -> g.apply((ListTemplateSharesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String templateArn;
        private List<TemplateShareSummary> templateShareSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplateSharesResponse model) {
            super(model);
            this.templateArn(model.templateArn);
            this.templateShareSummaries(model.templateShareSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getTemplateArn() {
            return this.templateArn;
        }

        public final void setTemplateArn(String templateArn) {
            this.templateArn = templateArn;
        }

        @Override
        public final Builder templateArn(String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        public final List<TemplateShareSummary.Builder> getTemplateShareSummaries() {
            List<TemplateShareSummary.Builder> result = TemplateShareSummariesCopier.copyToBuilder(this.templateShareSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateShareSummaries(Collection<TemplateShareSummary.BuilderImpl> templateShareSummaries) {
            this.templateShareSummaries = TemplateShareSummariesCopier.copyFromBuilder(templateShareSummaries);
        }

        @Override
        public final Builder templateShareSummaries(Collection<TemplateShareSummary> templateShareSummaries) {
            this.templateShareSummaries = TemplateShareSummariesCopier.copy(templateShareSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateShareSummaries(TemplateShareSummary ... templateShareSummaries) {
            this.templateShareSummaries(Arrays.asList(templateShareSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateShareSummaries(Consumer<TemplateShareSummary.Builder> ... templateShareSummaries) {
            this.templateShareSummaries(Stream.of(templateShareSummaries).map(c -> (TemplateShareSummary)((TemplateShareSummary.Builder)TemplateShareSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTemplateSharesResponse build() {
            return new ListTemplateSharesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTemplateSharesResponse> {
        public Builder templateArn(String var1);

        public Builder templateShareSummaries(Collection<TemplateShareSummary> var1);

        public Builder templateShareSummaries(TemplateShareSummary ... var1);

        public Builder templateShareSummaries(Consumer<TemplateShareSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

