/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.internal.UserAgentUtils;
import software.amazon.awssdk.services.wellarchitected.model.ListProfilesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListProfilesResponse;

public class ListProfilesIterable
implements SdkIterable<ListProfilesResponse> {
    private final WellArchitectedClient client;
    private final ListProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProfilesIterable(WellArchitectedClient client, ListProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProfilesResponseFetcher();
    }

    public Iterator<ListProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProfilesResponseFetcher
    implements SyncPageFetcher<ListProfilesResponse> {
        private ListProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProfilesResponse nextPage(ListProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListProfilesIterable.this.client.listProfiles(ListProfilesIterable.this.firstRequest);
            }
            return ListProfilesIterable.this.client.listProfiles((ListProfilesRequest)((Object)ListProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

