/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProfileTemplateResponse extends WellArchitectedResponse implements
        ToCopyableBuilder<GetProfileTemplateResponse.Builder, GetProfileTemplateResponse> {
    private static final SdkField<ProfileTemplate> PROFILE_TEMPLATE_FIELD = SdkField
            .<ProfileTemplate> builder(MarshallingType.SDK_POJO).memberName("ProfileTemplate")
            .getter(getter(GetProfileTemplateResponse::profileTemplate)).setter(setter(Builder::profileTemplate))
            .constructor(ProfileTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileTemplate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_TEMPLATE_FIELD));

    private final ProfileTemplate profileTemplate;

    private GetProfileTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.profileTemplate = builder.profileTemplate;
    }

    /**
     * <p>
     * The profile template.
     * </p>
     * 
     * @return The profile template.
     */
    public final ProfileTemplate profileTemplate() {
        return profileTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileTemplateResponse)) {
            return false;
        }
        GetProfileTemplateResponse other = (GetProfileTemplateResponse) obj;
        return Objects.equals(profileTemplate(), other.profileTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProfileTemplateResponse").add("ProfileTemplate", profileTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileTemplate":
            return Optional.ofNullable(clazz.cast(profileTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProfileTemplateResponse, T> g) {
        return obj -> g.apply((GetProfileTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProfileTemplateResponse> {
        /**
         * <p>
         * The profile template.
         * </p>
         * 
         * @param profileTemplate
         *        The profile template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileTemplate(ProfileTemplate profileTemplate);

        /**
         * <p>
         * The profile template.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileTemplate.Builder} avoiding the
         * need to create one manually via {@link ProfileTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileTemplate.Builder#build()} is called immediately and its
         * result is passed to {@link #profileTemplate(ProfileTemplate)}.
         * 
         * @param profileTemplate
         *        a consumer that will call methods on {@link ProfileTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profileTemplate(ProfileTemplate)
         */
        default Builder profileTemplate(Consumer<ProfileTemplate.Builder> profileTemplate) {
            return profileTemplate(ProfileTemplate.builder().applyMutation(profileTemplate).build());
        }
    }

    static final class BuilderImpl extends WellArchitectedResponse.BuilderImpl implements Builder {
        private ProfileTemplate profileTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileTemplateResponse model) {
            super(model);
            profileTemplate(model.profileTemplate);
        }

        public final ProfileTemplate.Builder getProfileTemplate() {
            return profileTemplate != null ? profileTemplate.toBuilder() : null;
        }

        public final void setProfileTemplate(ProfileTemplate.BuilderImpl profileTemplate) {
            this.profileTemplate = profileTemplate != null ? profileTemplate.build() : null;
        }

        @Override
        public final Builder profileTemplate(ProfileTemplate profileTemplate) {
            this.profileTemplate = profileTemplate;
            return this;
        }

        @Override
        public GetProfileTemplateResponse build() {
            return new GetProfileTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
