/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConsolidatedReportRequest extends WellArchitectedRequest implements
        ToCopyableBuilder<GetConsolidatedReportRequest.Builder, GetConsolidatedReportRequest> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(GetConsolidatedReportRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Format").build()).build();

    private static final SdkField<Boolean> INCLUDE_SHARED_RESOURCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeSharedResources")
            .getter(getter(GetConsolidatedReportRequest::includeSharedResources))
            .setter(setter(Builder::includeSharedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("IncludeSharedResources").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetConsolidatedReportRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetConsolidatedReportRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD,
            INCLUDE_SHARED_RESOURCES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String format;

    private final Boolean includeSharedResources;

    private final String nextToken;

    private final Integer maxResults;

    private GetConsolidatedReportRequest(BuilderImpl builder) {
        super(builder);
        this.format = builder.format;
        this.includeSharedResources = builder.includeSharedResources;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The format of the consolidated report.
     * </p>
     * <p>
     * For <code>PDF</code>, <code>Base64String</code> is returned. For <code>JSON</code>, <code>Metrics</code> is
     * returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ReportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the consolidated report.</p>
     *         <p>
     *         For <code>PDF</code>, <code>Base64String</code> is returned. For <code>JSON</code>, <code>Metrics</code>
     *         is returned.
     * @see ReportFormat
     */
    public final ReportFormat format() {
        return ReportFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the consolidated report.
     * </p>
     * <p>
     * For <code>PDF</code>, <code>Base64String</code> is returned. For <code>JSON</code>, <code>Metrics</code> is
     * returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ReportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the consolidated report.</p>
     *         <p>
     *         For <code>PDF</code>, <code>Base64String</code> is returned. For <code>JSON</code>, <code>Metrics</code>
     *         is returned.
     * @see ReportFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * Set to <code>true</code> to have shared resources included in the report.
     * </p>
     * 
     * @return Set to <code>true</code> to have shared resources included in the report.
     */
    public final Boolean includeSharedResources() {
        return includeSharedResources;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for this request.
     * </p>
     * 
     * @return The maximum number of results to return for this request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeSharedResources());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsolidatedReportRequest)) {
            return false;
        }
        GetConsolidatedReportRequest other = (GetConsolidatedReportRequest) obj;
        return Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(includeSharedResources(), other.includeSharedResources())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConsolidatedReportRequest").add("Format", formatAsString())
                .add("IncludeSharedResources", includeSharedResources()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "IncludeSharedResources":
            return Optional.ofNullable(clazz.cast(includeSharedResources()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConsolidatedReportRequest, T> g) {
        return obj -> g.apply((GetConsolidatedReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WellArchitectedRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConsolidatedReportRequest> {
        /**
         * <p>
         * The format of the consolidated report.
         * </p>
         * <p>
         * For <code>PDF</code>, <code>Base64String</code> is returned. For <code>JSON</code>, <code>Metrics</code> is
         * returned.
         * </p>
         * 
         * @param format
         *        The format of the consolidated report.</p>
         *        <p>
         *        For <code>PDF</code>, <code>Base64String</code> is returned. For <code>JSON</code>,
         *        <code>Metrics</code> is returned.
         * @see ReportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the consolidated report.
         * </p>
         * <p>
         * For <code>PDF</code>, <code>Base64String</code> is returned. For <code>JSON</code>, <code>Metrics</code> is
         * returned.
         * </p>
         * 
         * @param format
         *        The format of the consolidated report.</p>
         *        <p>
         *        For <code>PDF</code>, <code>Base64String</code> is returned. For <code>JSON</code>,
         *        <code>Metrics</code> is returned.
         * @see ReportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportFormat
         */
        Builder format(ReportFormat format);

        /**
         * <p>
         * Set to <code>true</code> to have shared resources included in the report.
         * </p>
         * 
         * @param includeSharedResources
         *        Set to <code>true</code> to have shared resources included in the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeSharedResources(Boolean includeSharedResources);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for this request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WellArchitectedRequest.BuilderImpl implements Builder {
        private String format;

        private Boolean includeSharedResources;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsolidatedReportRequest model) {
            super(model);
            format(model.format);
            includeSharedResources(model.includeSharedResources);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ReportFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Boolean getIncludeSharedResources() {
            return includeSharedResources;
        }

        public final void setIncludeSharedResources(Boolean includeSharedResources) {
            this.includeSharedResources = includeSharedResources;
        }

        @Override
        public final Builder includeSharedResources(Boolean includeSharedResources) {
            this.includeSharedResources = includeSharedResources;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConsolidatedReportRequest build() {
            return new GetConsolidatedReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
