/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListProfileNotificationsResponse;

public class ListProfileNotificationsIterable
implements SdkIterable<ListProfileNotificationsResponse> {
    private final WellArchitectedClient client;
    private final ListProfileNotificationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProfileNotificationsIterable(WellArchitectedClient client, ListProfileNotificationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListProfileNotificationsResponseFetcher();
    }

    public Iterator<ListProfileNotificationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProfileNotificationsResponseFetcher
    implements SyncPageFetcher<ListProfileNotificationsResponse> {
        private ListProfileNotificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListProfileNotificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProfileNotificationsResponse nextPage(ListProfileNotificationsResponse previousPage) {
            if (previousPage == null) {
                return ListProfileNotificationsIterable.this.client.listProfileNotifications(ListProfileNotificationsIterable.this.firstRequest);
            }
            return ListProfileNotificationsIterable.this.client.listProfileNotifications((ListProfileNotificationsRequest)((Object)ListProfileNotificationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

