/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedServiceClientConfiguration;
import software.amazon.awssdk.services.wellarchitected.model.AccessDeniedException;
import software.amazon.awssdk.services.wellarchitected.model.AssociateLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.AssociateLensesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ConflictException;
import software.amazon.awssdk.services.wellarchitected.model.CreateLensShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateLensShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateLensVersionRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateLensVersionResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateMilestoneRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateMilestoneResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.CreateWorkloadShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteLensRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteLensResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteLensShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteLensShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.DeleteWorkloadShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.DisassociateLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.DisassociateLensesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ExportLensRequest;
import software.amazon.awssdk.services.wellarchitected.model.ExportLensResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetAnswerRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetAnswerResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetConsolidatedReportResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewReportRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewReportResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetLensVersionDifferenceRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetLensVersionDifferenceResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetMilestoneRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetMilestoneResponse;
import software.amazon.awssdk.services.wellarchitected.model.GetWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.GetWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.ImportLensRequest;
import software.amazon.awssdk.services.wellarchitected.model.ImportLensResponse;
import software.amazon.awssdk.services.wellarchitected.model.InternalServerException;
import software.amazon.awssdk.services.wellarchitected.model.ListAnswersRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListAnswersResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckDetailsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListCheckSummariesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewImprovementsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensReviewsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensSharesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListMilestonesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListMilestonesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListNotificationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListNotificationsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesResponse;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadsResponse;
import software.amazon.awssdk.services.wellarchitected.model.ResourceNotFoundException;
import software.amazon.awssdk.services.wellarchitected.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.wellarchitected.model.TagResourceRequest;
import software.amazon.awssdk.services.wellarchitected.model.TagResourceResponse;
import software.amazon.awssdk.services.wellarchitected.model.ThrottlingException;
import software.amazon.awssdk.services.wellarchitected.model.UntagResourceRequest;
import software.amazon.awssdk.services.wellarchitected.model.UntagResourceResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateAnswerRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateAnswerResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateGlobalSettingsRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateGlobalSettingsResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateShareInvitationRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateShareInvitationResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadShareRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpdateWorkloadShareResponse;
import software.amazon.awssdk.services.wellarchitected.model.UpgradeLensReviewRequest;
import software.amazon.awssdk.services.wellarchitected.model.UpgradeLensReviewResponse;
import software.amazon.awssdk.services.wellarchitected.model.ValidationException;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedException;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.services.wellarchitected.paginators.GetConsolidatedReportIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListAnswersIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListCheckDetailsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListCheckSummariesIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewImprovementsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensReviewsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensSharesIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListLensesIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListMilestonesIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListNotificationsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListShareInvitationsIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadSharesIterable;
import software.amazon.awssdk.services.wellarchitected.paginators.ListWorkloadsIterable;
import software.amazon.awssdk.services.wellarchitected.transform.AssociateLensesRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.CreateLensShareRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.CreateLensVersionRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.CreateMilestoneRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.CreateWorkloadRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.CreateWorkloadShareRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.DeleteLensRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.DeleteLensShareRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.DeleteWorkloadRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.DeleteWorkloadShareRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.DisassociateLensesRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ExportLensRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetAnswerRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetConsolidatedReportRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetLensRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetLensReviewReportRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetLensReviewRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetLensVersionDifferenceRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetMilestoneRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.GetWorkloadRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ImportLensRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListAnswersRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListCheckDetailsRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListCheckSummariesRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListLensReviewImprovementsRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListLensReviewsRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListLensSharesRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListLensesRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListMilestonesRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListNotificationsRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListShareInvitationsRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListWorkloadSharesRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.ListWorkloadsRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpdateAnswerRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpdateGlobalSettingsRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpdateLensReviewRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpdateShareInvitationRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpdateWorkloadRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpdateWorkloadShareRequestMarshaller;
import software.amazon.awssdk.services.wellarchitected.transform.UpgradeLensReviewRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultWellArchitectedClient
implements WellArchitectedClient {
    private static final Logger log = Logger.loggerFor(DefaultWellArchitectedClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final WellArchitectedServiceClientConfiguration serviceClientConfiguration;

    protected DefaultWellArchitectedClient(WellArchitectedServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateLensesResponse associateLenses(AssociateLensesRequest associateLensesRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateLensesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, associateLensesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateLenses");
            AssociateLensesResponse associateLensesResponse = (AssociateLensesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateLenses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateLensesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateLensesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateLensesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$associateLenses$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLensShareResponse createLensShare(CreateLensShareRequest createLensShareRequest) throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLensShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, createLensShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLensShare");
            CreateLensShareResponse createLensShareResponse = (CreateLensShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLensShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLensShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLensShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLensShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$createLensShare$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLensVersionResponse createLensVersion(CreateLensVersionRequest createLensVersionRequest) throws ValidationException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLensVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, createLensVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLensVersion");
            CreateLensVersionResponse createLensVersionResponse = (CreateLensVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLensVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLensVersionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLensVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLensVersionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$createLensVersion$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMilestoneResponse createMilestone(CreateMilestoneRequest createMilestoneRequest) throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMilestoneResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, createMilestoneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMilestone");
            CreateMilestoneResponse createMilestoneResponse = (CreateMilestoneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMilestone").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createMilestoneRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMilestoneRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMilestoneResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$createMilestone$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkloadResponse createWorkload(CreateWorkloadRequest createWorkloadRequest) throws ValidationException, ConflictException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkloadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, createWorkloadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkload");
            CreateWorkloadResponse createWorkloadResponse = (CreateWorkloadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkloadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkloadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkloadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$createWorkload$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkloadShareResponse createWorkloadShare(CreateWorkloadShareRequest createWorkloadShareRequest) throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkloadShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, createWorkloadShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkloadShare");
            CreateWorkloadShareResponse createWorkloadShareResponse = (CreateWorkloadShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkloadShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWorkloadShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkloadShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkloadShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$createWorkloadShare$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLensResponse deleteLens(DeleteLensRequest deleteLensRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLensResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, deleteLensRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLens");
            DeleteLensResponse deleteLensResponse = (DeleteLensResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLens").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLensRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLensRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLensResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$deleteLens$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLensShareResponse deleteLensShare(DeleteLensShareRequest deleteLensShareRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLensShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, deleteLensShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLensShare");
            DeleteLensShareResponse deleteLensShareResponse = (DeleteLensShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLensShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLensShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLensShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLensShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$deleteLensShare$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkloadResponse deleteWorkload(DeleteWorkloadRequest deleteWorkloadRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkloadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkloadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkload");
            DeleteWorkloadResponse deleteWorkloadResponse = (DeleteWorkloadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkloadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkloadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkloadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$deleteWorkload$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkloadShareResponse deleteWorkloadShare(DeleteWorkloadShareRequest deleteWorkloadShareRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkloadShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkloadShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkloadShare");
            DeleteWorkloadShareResponse deleteWorkloadShareResponse = (DeleteWorkloadShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkloadShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWorkloadShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkloadShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkloadShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$deleteWorkloadShare$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateLensesResponse disassociateLenses(DisassociateLensesRequest disassociateLensesRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateLensesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, disassociateLensesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateLenses");
            DisassociateLensesResponse disassociateLensesResponse = (DisassociateLensesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateLenses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateLensesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateLensesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateLensesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$disassociateLenses$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExportLensResponse exportLens(ExportLensRequest exportLensRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportLensResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, exportLensRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportLens");
            ExportLensResponse exportLensResponse = (ExportLensResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportLens").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)exportLensRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExportLensRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return exportLensResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$exportLens$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnswerResponse getAnswer(GetAnswerRequest getAnswerRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnswerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getAnswerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnswer");
            GetAnswerResponse getAnswerResponse = (GetAnswerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnswer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAnswerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAnswerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnswerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getAnswer$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConsolidatedReportResponse getConsolidatedReport(GetConsolidatedReportRequest getConsolidatedReportRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConsolidatedReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getConsolidatedReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConsolidatedReport");
            GetConsolidatedReportResponse getConsolidatedReportResponse = (GetConsolidatedReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConsolidatedReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConsolidatedReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetConsolidatedReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConsolidatedReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getConsolidatedReport$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetConsolidatedReportIterable getConsolidatedReportPaginator(GetConsolidatedReportRequest getConsolidatedReportRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, ConflictException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new GetConsolidatedReportIterable(this, this.applyPaginatorUserAgent(getConsolidatedReportRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLensResponse getLens(GetLensRequest getLensRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLensResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getLensRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLens");
            GetLensResponse getLensResponse = (GetLensResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLens").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLensRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLensRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLensResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getLens$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLensReviewResponse getLensReview(GetLensReviewRequest getLensReviewRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLensReviewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getLensReviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLensReview");
            GetLensReviewResponse getLensReviewResponse = (GetLensReviewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLensReview").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLensReviewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLensReviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLensReviewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getLensReview$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLensReviewReportResponse getLensReviewReport(GetLensReviewReportRequest getLensReviewReportRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLensReviewReportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getLensReviewReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLensReviewReport");
            GetLensReviewReportResponse getLensReviewReportResponse = (GetLensReviewReportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLensReviewReport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLensReviewReportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLensReviewReportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLensReviewReportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getLensReviewReport$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLensVersionDifferenceResponse getLensVersionDifference(GetLensVersionDifferenceRequest getLensVersionDifferenceRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLensVersionDifferenceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getLensVersionDifferenceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLensVersionDifference");
            GetLensVersionDifferenceResponse getLensVersionDifferenceResponse = (GetLensVersionDifferenceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLensVersionDifference").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLensVersionDifferenceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLensVersionDifferenceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLensVersionDifferenceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getLensVersionDifference$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMilestoneResponse getMilestone(GetMilestoneRequest getMilestoneRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMilestoneResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getMilestoneRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMilestone");
            GetMilestoneResponse getMilestoneResponse = (GetMilestoneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMilestone").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMilestoneRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMilestoneRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getMilestoneResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getMilestone$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkloadResponse getWorkload(GetWorkloadRequest getWorkloadRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkloadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, getWorkloadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkload");
            GetWorkloadResponse getWorkloadResponse = (GetWorkloadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getWorkloadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetWorkloadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWorkloadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$getWorkload$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportLensResponse importLens(ImportLensRequest importLensRequest) throws ValidationException, ConflictException, ResourceNotFoundException, ServiceQuotaExceededException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportLensResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, importLensRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportLens");
            ImportLensResponse importLensResponse = (ImportLensResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportLens").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importLensRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportLensRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importLensResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$importLens$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnswersResponse listAnswers(ListAnswersRequest listAnswersRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnswersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listAnswersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnswers");
            ListAnswersResponse listAnswersResponse = (ListAnswersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnswers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAnswersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAnswersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnswersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listAnswers$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAnswersIterable listAnswersPaginator(ListAnswersRequest listAnswersRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListAnswersIterable(this, this.applyPaginatorUserAgent(listAnswersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCheckDetailsResponse listCheckDetails(ListCheckDetailsRequest listCheckDetailsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCheckDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listCheckDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCheckDetails");
            ListCheckDetailsResponse listCheckDetailsResponse = (ListCheckDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCheckDetails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCheckDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCheckDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCheckDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listCheckDetails$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCheckDetailsIterable listCheckDetailsPaginator(ListCheckDetailsRequest listCheckDetailsRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListCheckDetailsIterable(this, this.applyPaginatorUserAgent(listCheckDetailsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCheckSummariesResponse listCheckSummaries(ListCheckSummariesRequest listCheckSummariesRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCheckSummariesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listCheckSummariesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCheckSummaries");
            ListCheckSummariesResponse listCheckSummariesResponse = (ListCheckSummariesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCheckSummaries").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCheckSummariesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCheckSummariesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCheckSummariesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listCheckSummaries$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCheckSummariesIterable listCheckSummariesPaginator(ListCheckSummariesRequest listCheckSummariesRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListCheckSummariesIterable(this, this.applyPaginatorUserAgent(listCheckSummariesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLensReviewImprovementsResponse listLensReviewImprovements(ListLensReviewImprovementsRequest listLensReviewImprovementsRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLensReviewImprovementsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listLensReviewImprovementsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLensReviewImprovements");
            ListLensReviewImprovementsResponse listLensReviewImprovementsResponse = (ListLensReviewImprovementsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLensReviewImprovements").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLensReviewImprovementsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLensReviewImprovementsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLensReviewImprovementsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listLensReviewImprovements$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListLensReviewImprovementsIterable listLensReviewImprovementsPaginator(ListLensReviewImprovementsRequest listLensReviewImprovementsRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListLensReviewImprovementsIterable(this, this.applyPaginatorUserAgent(listLensReviewImprovementsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLensReviewsResponse listLensReviews(ListLensReviewsRequest listLensReviewsRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLensReviewsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listLensReviewsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLensReviews");
            ListLensReviewsResponse listLensReviewsResponse = (ListLensReviewsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLensReviews").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLensReviewsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLensReviewsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLensReviewsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listLensReviews$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListLensReviewsIterable listLensReviewsPaginator(ListLensReviewsRequest listLensReviewsRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListLensReviewsIterable(this, this.applyPaginatorUserAgent(listLensReviewsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLensSharesResponse listLensShares(ListLensSharesRequest listLensSharesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLensSharesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listLensSharesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLensShares");
            ListLensSharesResponse listLensSharesResponse = (ListLensSharesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLensShares").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLensSharesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLensSharesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLensSharesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listLensShares$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListLensSharesIterable listLensSharesPaginator(ListLensSharesRequest listLensSharesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListLensSharesIterable(this, this.applyPaginatorUserAgent(listLensSharesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLensesResponse listLenses(ListLensesRequest listLensesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLensesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listLensesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLenses");
            ListLensesResponse listLensesResponse = (ListLensesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLenses").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLensesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLensesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLensesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listLenses$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListLensesIterable listLensesPaginator(ListLensesRequest listLensesRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListLensesIterable(this, this.applyPaginatorUserAgent(listLensesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMilestonesResponse listMilestones(ListMilestonesRequest listMilestonesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMilestonesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listMilestonesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMilestones");
            ListMilestonesResponse listMilestonesResponse = (ListMilestonesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMilestones").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listMilestonesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMilestonesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMilestonesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listMilestones$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMilestonesIterable listMilestonesPaginator(ListMilestonesRequest listMilestonesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListMilestonesIterable(this, this.applyPaginatorUserAgent(listMilestonesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNotificationsResponse listNotifications(ListNotificationsRequest listNotificationsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNotificationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listNotificationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNotifications");
            ListNotificationsResponse listNotificationsResponse = (ListNotificationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNotifications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listNotificationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNotificationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNotificationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listNotifications$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListNotificationsIterable listNotificationsPaginator(ListNotificationsRequest listNotificationsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListNotificationsIterable(this, this.applyPaginatorUserAgent(listNotificationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListShareInvitationsResponse listShareInvitations(ListShareInvitationsRequest listShareInvitationsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListShareInvitationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listShareInvitationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListShareInvitations");
            ListShareInvitationsResponse listShareInvitationsResponse = (ListShareInvitationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListShareInvitations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listShareInvitationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListShareInvitationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listShareInvitationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listShareInvitations$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListShareInvitationsIterable listShareInvitationsPaginator(ListShareInvitationsRequest listShareInvitationsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListShareInvitationsIterable(this, this.applyPaginatorUserAgent(listShareInvitationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listTagsForResource$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkloadSharesResponse listWorkloadShares(ListWorkloadSharesRequest listWorkloadSharesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkloadSharesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listWorkloadSharesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkloadShares");
            ListWorkloadSharesResponse listWorkloadSharesResponse = (ListWorkloadSharesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkloadShares").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkloadSharesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkloadSharesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkloadSharesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listWorkloadShares$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorkloadSharesIterable listWorkloadSharesPaginator(ListWorkloadSharesRequest listWorkloadSharesRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListWorkloadSharesIterable(this, this.applyPaginatorUserAgent(listWorkloadSharesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkloadsResponse listWorkloads(ListWorkloadsRequest listWorkloadsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkloadsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, listWorkloadsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkloads");
            ListWorkloadsResponse listWorkloadsResponse = (ListWorkloadsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkloads").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWorkloadsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkloadsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkloadsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$listWorkloads$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorkloadsIterable listWorkloadsPaginator(ListWorkloadsRequest listWorkloadsRequest) throws ValidationException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        return new ListWorkloadsIterable(this, this.applyPaginatorUserAgent(listWorkloadsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$tagResource$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$untagResource$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAnswerResponse updateAnswer(UpdateAnswerRequest updateAnswerRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAnswerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, updateAnswerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAnswer");
            UpdateAnswerResponse updateAnswerResponse = (UpdateAnswerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAnswer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAnswerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAnswerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAnswerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$updateAnswer$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGlobalSettingsResponse updateGlobalSettings(UpdateGlobalSettingsRequest updateGlobalSettingsRequest) throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalSettingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, updateGlobalSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGlobalSettings");
            UpdateGlobalSettingsResponse updateGlobalSettingsResponse = (UpdateGlobalSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalSettings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGlobalSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGlobalSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGlobalSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$updateGlobalSettings$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLensReviewResponse updateLensReview(UpdateLensReviewRequest updateLensReviewRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLensReviewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, updateLensReviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLensReview");
            UpdateLensReviewResponse updateLensReviewResponse = (UpdateLensReviewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLensReview").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLensReviewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLensReviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLensReviewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$updateLensReview$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateShareInvitationResponse updateShareInvitation(UpdateShareInvitationRequest updateShareInvitationRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateShareInvitationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, updateShareInvitationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateShareInvitation");
            UpdateShareInvitationResponse updateShareInvitationResponse = (UpdateShareInvitationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateShareInvitation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateShareInvitationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateShareInvitationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateShareInvitationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$updateShareInvitation$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkloadResponse updateWorkload(UpdateWorkloadRequest updateWorkloadRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkloadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, updateWorkloadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorkload");
            UpdateWorkloadResponse updateWorkloadResponse = (UpdateWorkloadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWorkloadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWorkloadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWorkloadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$updateWorkload$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkloadShareResponse updateWorkloadShare(UpdateWorkloadShareRequest updateWorkloadShareRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ConflictException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkloadShareResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, updateWorkloadShareRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorkloadShare");
            UpdateWorkloadShareResponse updateWorkloadShareResponse = (UpdateWorkloadShareResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkloadShare").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWorkloadShareRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWorkloadShareRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWorkloadShareResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$updateWorkloadShare$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpgradeLensReviewResponse upgradeLensReview(UpgradeLensReviewRequest upgradeLensReviewRequest) throws ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, WellArchitectedException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpgradeLensReviewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultWellArchitectedClient.resolveMetricPublishers(this.clientConfiguration, upgradeLensReviewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WellArchitected");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpgradeLensReview");
            UpgradeLensReviewResponse upgradeLensReviewResponse = (UpgradeLensReviewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpgradeLensReview").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)upgradeLensReviewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpgradeLensReviewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return upgradeLensReviewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWellArchitectedClient.lambda$upgradeLensReview$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends WellArchitectedRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.84").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((WellArchitectedRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "wellarchitected";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WellArchitectedException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").contentType("application/json").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final WellArchitectedServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$upgradeLensReview$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateWorkloadShare$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateWorkload$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateShareInvitation$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLensReview$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGlobalSettings$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAnswer$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkloads$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkloadShares$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listShareInvitations$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNotifications$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMilestones$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLenses$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLensShares$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLensReviews$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLensReviewImprovements$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCheckSummaries$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCheckDetails$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnswers$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importLens$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkload$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMilestone$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLensVersionDifference$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLensReviewReport$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLensReview$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLens$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConsolidatedReport$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnswer$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportLens$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateLenses$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkloadShare$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkload$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLensShare$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLens$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkloadShare$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkload$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMilestone$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLensVersion$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLensShare$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateLenses$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

