/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProfileNotificationType {
    PROFILE_ANSWERS_UPDATED("PROFILE_ANSWERS_UPDATED"),
    PROFILE_DELETED("PROFILE_DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProfileNotificationType> VALUE_MAP;
    private final String value;

    private ProfileNotificationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProfileNotificationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProfileNotificationType> knownValues() {
        EnumSet<ProfileNotificationType> knownValues = EnumSet.allOf(ProfileNotificationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProfileNotificationType.class, ProfileNotificationType::toString);
    }
}

