/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LensStatus {
    CURRENT("CURRENT"),
    NOT_CURRENT("NOT_CURRENT"),
    DEPRECATED("DEPRECATED"),
    DELETED("DELETED"),
    UNSHARED("UNSHARED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LensStatus> VALUE_MAP;
    private final String value;

    private LensStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LensStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LensStatus> knownValues() {
        EnumSet<LensStatus> knownValues = EnumSet.allOf(LensStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LensStatus.class, LensStatus::toString);
    }
}

