/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListShareInvitationsResponse;

public class ListShareInvitationsPublisher
implements SdkPublisher<ListShareInvitationsResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListShareInvitationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListShareInvitationsPublisher(WellArchitectedAsyncClient client, ListShareInvitationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListShareInvitationsPublisher(WellArchitectedAsyncClient client, ListShareInvitationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListShareInvitationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListShareInvitationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListShareInvitationsResponseFetcher
    implements AsyncPageFetcher<ListShareInvitationsResponse> {
        private ListShareInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(ListShareInvitationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListShareInvitationsResponse> nextPage(ListShareInvitationsResponse previousPage) {
            if (previousPage == null) {
                return ListShareInvitationsPublisher.this.client.listShareInvitations(ListShareInvitationsPublisher.this.firstRequest);
            }
            return ListShareInvitationsPublisher.this.client.listShareInvitations((ListShareInvitationsRequest)((Object)ListShareInvitationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

