/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ChoiceReason {
    OUT_OF_SCOPE("OUT_OF_SCOPE"),
    BUSINESS_PRIORITIES("BUSINESS_PRIORITIES"),
    ARCHITECTURE_CONSTRAINTS("ARCHITECTURE_CONSTRAINTS"),
    OTHER("OTHER"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ChoiceReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChoiceReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ChoiceReason.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChoiceReason> knownValues() {
        return Stream.of(ChoiceReason.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

