/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkloadsResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListWorkloadsResponse> {
    private static final SdkField<List<WorkloadSummary>> WORKLOAD_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkloadSummaries").getter(ListWorkloadsResponse.getter(ListWorkloadsResponse::workloadSummaries)).setter(ListWorkloadsResponse.setter(Builder::workloadSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkloadSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWorkloadsResponse.getter(ListWorkloadsResponse::nextToken)).setter(ListWorkloadsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<WorkloadSummary> workloadSummaries;
    private final String nextToken;

    private ListWorkloadsResponse(BuilderImpl builder) {
        super(builder);
        this.workloadSummaries = builder.workloadSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasWorkloadSummaries() {
        return this.workloadSummaries != null && !(this.workloadSummaries instanceof SdkAutoConstructList);
    }

    public final List<WorkloadSummary> workloadSummaries() {
        return this.workloadSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkloadSummaries() ? this.workloadSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkloadsResponse)) {
            return false;
        }
        ListWorkloadsResponse other = (ListWorkloadsResponse)((Object)obj);
        return this.hasWorkloadSummaries() == other.hasWorkloadSummaries() && Objects.equals(this.workloadSummaries(), other.workloadSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkloadsResponse").add("WorkloadSummaries", this.hasWorkloadSummaries() ? this.workloadSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadSummaries": {
                return Optional.ofNullable(clazz.cast(this.workloadSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkloadsResponse, T> g) {
        return obj -> g.apply((ListWorkloadsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private List<WorkloadSummary> workloadSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkloadsResponse model) {
            super(model);
            this.workloadSummaries(model.workloadSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<WorkloadSummary.Builder> getWorkloadSummaries() {
            List<WorkloadSummary.Builder> result = WorkloadSummariesCopier.copyToBuilder(this.workloadSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkloadSummaries(Collection<WorkloadSummary.BuilderImpl> workloadSummaries) {
            this.workloadSummaries = WorkloadSummariesCopier.copyFromBuilder(workloadSummaries);
        }

        @Override
        public final Builder workloadSummaries(Collection<WorkloadSummary> workloadSummaries) {
            this.workloadSummaries = WorkloadSummariesCopier.copy(workloadSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadSummaries(WorkloadSummary ... workloadSummaries) {
            this.workloadSummaries(Arrays.asList(workloadSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadSummaries(Consumer<WorkloadSummary.Builder> ... workloadSummaries) {
            this.workloadSummaries(Stream.of(workloadSummaries).map(c -> (WorkloadSummary)((WorkloadSummary.Builder)WorkloadSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkloadsResponse build() {
            return new ListWorkloadsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkloadsResponse> {
        public Builder workloadSummaries(Collection<WorkloadSummary> var1);

        public Builder workloadSummaries(WorkloadSummary ... var1);

        public Builder workloadSummaries(Consumer<WorkloadSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

