/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.PillarNotesCopier;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLensReviewRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, UpdateLensReviewRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(UpdateLensReviewRequest.getter(UpdateLensReviewRequest::workloadId)).setter(UpdateLensReviewRequest.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(UpdateLensReviewRequest.getter(UpdateLensReviewRequest::lensAlias)).setter(UpdateLensReviewRequest.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()}).build();
    private static final SdkField<String> LENS_NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensNotes").getter(UpdateLensReviewRequest.getter(UpdateLensReviewRequest::lensNotes)).setter(UpdateLensReviewRequest.setter(Builder::lensNotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensNotes").build()}).build();
    private static final SdkField<Map<String, String>> PILLAR_NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PillarNotes").getter(UpdateLensReviewRequest.getter(UpdateLensReviewRequest::pillarNotes)).setter(UpdateLensReviewRequest.setter(Builder::pillarNotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarNotes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, LENS_ALIAS_FIELD, LENS_NOTES_FIELD, PILLAR_NOTES_FIELD));
    private final String workloadId;
    private final String lensAlias;
    private final String lensNotes;
    private final Map<String, String> pillarNotes;

    private UpdateLensReviewRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.lensAlias = builder.lensAlias;
        this.lensNotes = builder.lensNotes;
        this.pillarNotes = builder.pillarNotes;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String lensNotes() {
        return this.lensNotes;
    }

    public final boolean hasPillarNotes() {
        return this.pillarNotes != null && !(this.pillarNotes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> pillarNotes() {
        return this.pillarNotes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensNotes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPillarNotes() ? this.pillarNotes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLensReviewRequest)) {
            return false;
        }
        UpdateLensReviewRequest other = (UpdateLensReviewRequest)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.lensNotes(), other.lensNotes()) && this.hasPillarNotes() == other.hasPillarNotes() && Objects.equals(this.pillarNotes(), other.pillarNotes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLensReviewRequest").add("WorkloadId", (Object)this.workloadId()).add("LensAlias", (Object)this.lensAlias()).add("LensNotes", (Object)this.lensNotes()).add("PillarNotes", this.hasPillarNotes() ? this.pillarNotes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "LensNotes": {
                return Optional.ofNullable(clazz.cast(this.lensNotes()));
            }
            case "PillarNotes": {
                return Optional.ofNullable(clazz.cast(this.pillarNotes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLensReviewRequest, T> g) {
        return obj -> g.apply((UpdateLensReviewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String workloadId;
        private String lensAlias;
        private String lensNotes;
        private Map<String, String> pillarNotes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLensReviewRequest model) {
            super(model);
            this.workloadId(model.workloadId);
            this.lensAlias(model.lensAlias);
            this.lensNotes(model.lensNotes);
            this.pillarNotes(model.pillarNotes);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensNotes() {
            return this.lensNotes;
        }

        public final void setLensNotes(String lensNotes) {
            this.lensNotes = lensNotes;
        }

        @Override
        public final Builder lensNotes(String lensNotes) {
            this.lensNotes = lensNotes;
            return this;
        }

        public final Map<String, String> getPillarNotes() {
            if (this.pillarNotes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.pillarNotes;
        }

        public final void setPillarNotes(Map<String, String> pillarNotes) {
            this.pillarNotes = PillarNotesCopier.copy(pillarNotes);
        }

        @Override
        public final Builder pillarNotes(Map<String, String> pillarNotes) {
            this.pillarNotes = PillarNotesCopier.copy(pillarNotes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLensReviewRequest build() {
            return new UpdateLensReviewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLensReviewRequest> {
        public Builder workloadId(String var1);

        public Builder lensAlias(String var1);

        public Builder lensNotes(String var1);

        public Builder pillarNotes(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

