/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedAsyncClient;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListWorkloadSharesResponse;

public class ListWorkloadSharesPublisher
implements SdkPublisher<ListWorkloadSharesResponse> {
    private final WellArchitectedAsyncClient client;
    private final ListWorkloadSharesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkloadSharesPublisher(WellArchitectedAsyncClient client, ListWorkloadSharesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkloadSharesPublisher(WellArchitectedAsyncClient client, ListWorkloadSharesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkloadSharesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkloadSharesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListWorkloadSharesResponseFetcher
    implements AsyncPageFetcher<ListWorkloadSharesResponse> {
        private ListWorkloadSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkloadSharesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkloadSharesResponse> nextPage(ListWorkloadSharesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkloadSharesPublisher.this.client.listWorkloadShares(ListWorkloadSharesPublisher.this.firstRequest);
            }
            return ListWorkloadSharesPublisher.this.client.listWorkloadShares((ListWorkloadSharesRequest)((Object)ListWorkloadSharesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

