/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.LensStatusType;
import software.amazon.awssdk.services.wellarchitected.model.LensType;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLensesRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, ListLensesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLensesRequest.getter(ListLensesRequest::nextToken)).setter(ListLensesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListLensesRequest.getter(ListLensesRequest::maxResults)).setter(ListLensesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> LENS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensType").getter(ListLensesRequest.getter(ListLensesRequest::lensTypeAsString)).setter(ListLensesRequest.setter(Builder::lensType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LensType").build()}).build();
    private static final SdkField<String> LENS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensStatus").getter(ListLensesRequest.getter(ListLensesRequest::lensStatusAsString)).setter(ListLensesRequest.setter(Builder::lensStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LensStatus").build()}).build();
    private static final SdkField<String> LENS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensName").getter(ListLensesRequest.getter(ListLensesRequest::lensName)).setter(ListLensesRequest.setter(Builder::lensName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("LensName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LENS_TYPE_FIELD, LENS_STATUS_FIELD, LENS_NAME_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final String lensType;
    private final String lensStatus;
    private final String lensName;

    private ListLensesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.lensType = builder.lensType;
        this.lensStatus = builder.lensStatus;
        this.lensName = builder.lensName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final LensType lensType() {
        return LensType.fromValue(this.lensType);
    }

    public final String lensTypeAsString() {
        return this.lensType;
    }

    public final LensStatusType lensStatus() {
        return LensStatusType.fromValue(this.lensStatus);
    }

    public final String lensStatusAsString() {
        return this.lensStatus;
    }

    public final String lensName() {
        return this.lensName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLensesRequest)) {
            return false;
        }
        ListLensesRequest other = (ListLensesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.lensTypeAsString(), other.lensTypeAsString()) && Objects.equals(this.lensStatusAsString(), other.lensStatusAsString()) && Objects.equals(this.lensName(), other.lensName());
    }

    public final String toString() {
        return ToString.builder((String)"ListLensesRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("LensType", (Object)this.lensTypeAsString()).add("LensStatus", (Object)this.lensStatusAsString()).add("LensName", (Object)this.lensName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "LensType": {
                return Optional.ofNullable(clazz.cast(this.lensTypeAsString()));
            }
            case "LensStatus": {
                return Optional.ofNullable(clazz.cast(this.lensStatusAsString()));
            }
            case "LensName": {
                return Optional.ofNullable(clazz.cast(this.lensName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLensesRequest, T> g) {
        return obj -> g.apply((ListLensesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String lensType;
        private String lensStatus;
        private String lensName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLensesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.lensType(model.lensType);
            this.lensStatus(model.lensStatus);
            this.lensName(model.lensName);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getLensType() {
            return this.lensType;
        }

        public final void setLensType(String lensType) {
            this.lensType = lensType;
        }

        @Override
        @Transient
        public final Builder lensType(String lensType) {
            this.lensType = lensType;
            return this;
        }

        @Override
        @Transient
        public final Builder lensType(LensType lensType) {
            this.lensType(lensType == null ? null : lensType.toString());
            return this;
        }

        public final String getLensStatus() {
            return this.lensStatus;
        }

        public final void setLensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
        }

        @Override
        @Transient
        public final Builder lensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder lensStatus(LensStatusType lensStatus) {
            this.lensStatus(lensStatus == null ? null : lensStatus.toString());
            return this;
        }

        public final String getLensName() {
            return this.lensName;
        }

        public final void setLensName(String lensName) {
            this.lensName = lensName;
        }

        @Override
        @Transient
        public final Builder lensName(String lensName) {
            this.lensName = lensName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLensesRequest build() {
            return new ListLensesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLensesRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder lensType(String var1);

        public Builder lensType(LensType var1);

        public Builder lensStatus(String var1);

        public Builder lensStatus(LensStatusType var1);

        public Builder lensName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

