/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.PermissionType;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWorkloadShareRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, UpdateWorkloadShareRequest> {
    private static final SdkField<String> SHARE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShareId").getter(UpdateWorkloadShareRequest.getter(UpdateWorkloadShareRequest::shareId)).setter(UpdateWorkloadShareRequest.setter(Builder::shareId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ShareId").build()}).build();
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(UpdateWorkloadShareRequest.getter(UpdateWorkloadShareRequest::workloadId)).setter(UpdateWorkloadShareRequest.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionType").getter(UpdateWorkloadShareRequest.getter(UpdateWorkloadShareRequest::permissionTypeAsString)).setter(UpdateWorkloadShareRequest.setter(Builder::permissionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_ID_FIELD, WORKLOAD_ID_FIELD, PERMISSION_TYPE_FIELD));
    private final String shareId;
    private final String workloadId;
    private final String permissionType;

    private UpdateWorkloadShareRequest(BuilderImpl builder) {
        super(builder);
        this.shareId = builder.shareId;
        this.workloadId = builder.workloadId;
        this.permissionType = builder.permissionType;
    }

    public final String shareId() {
        return this.shareId;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final PermissionType permissionType() {
        return PermissionType.fromValue(this.permissionType);
    }

    public final String permissionTypeAsString() {
        return this.permissionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.shareId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkloadShareRequest)) {
            return false;
        }
        UpdateWorkloadShareRequest other = (UpdateWorkloadShareRequest)((Object)obj);
        return Objects.equals(this.shareId(), other.shareId()) && Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.permissionTypeAsString(), other.permissionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWorkloadShareRequest").add("ShareId", (Object)this.shareId()).add("WorkloadId", (Object)this.workloadId()).add("PermissionType", (Object)this.permissionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShareId": {
                return Optional.ofNullable(clazz.cast(this.shareId()));
            }
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "PermissionType": {
                return Optional.ofNullable(clazz.cast(this.permissionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkloadShareRequest, T> g) {
        return obj -> g.apply((UpdateWorkloadShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String shareId;
        private String workloadId;
        private String permissionType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkloadShareRequest model) {
            super(model);
            this.shareId(model.shareId);
            this.workloadId(model.workloadId);
            this.permissionType(model.permissionType);
        }

        public final String getShareId() {
            return this.shareId;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        @Override
        @Transient
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        @Transient
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getPermissionType() {
            return this.permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        @Transient
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        @Transient
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkloadShareRequest build() {
            return new UpdateWorkloadShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWorkloadShareRequest> {
        public Builder shareId(String var1);

        public Builder workloadId(String var1);

        public Builder permissionType(String var1);

        public Builder permissionType(PermissionType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

