/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkloadImprovementStatus {
    NOT_APPLICABLE("NOT_APPLICABLE"),
    NOT_STARTED("NOT_STARTED"),
    IN_PROGRESS("IN_PROGRESS"),
    COMPLETE("COMPLETE"),
    RISK_ACKNOWLEDGED("RISK_ACKNOWLEDGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkloadImprovementStatus> VALUE_MAP;
    private final String value;

    private WorkloadImprovementStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkloadImprovementStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkloadImprovementStatus> knownValues() {
        EnumSet<WorkloadImprovementStatus> knownValues = EnumSet.allOf(WorkloadImprovementStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkloadImprovementStatus.class, WorkloadImprovementStatus::toString);
    }
}

