/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.MilestoneSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.MilestoneSummary;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMilestonesResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListMilestonesResponse> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(ListMilestonesResponse.getter(ListMilestonesResponse::workloadId)).setter(ListMilestonesResponse.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<List<MilestoneSummary>> MILESTONE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MilestoneSummaries").getter(ListMilestonesResponse.getter(ListMilestonesResponse::milestoneSummaries)).setter(ListMilestonesResponse.setter(Builder::milestoneSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MilestoneSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MilestoneSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMilestonesResponse.getter(ListMilestonesResponse::nextToken)).setter(ListMilestonesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, MILESTONE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final String workloadId;
    private final List<MilestoneSummary> milestoneSummaries;
    private final String nextToken;

    private ListMilestonesResponse(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.milestoneSummaries = builder.milestoneSummaries;
        this.nextToken = builder.nextToken;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final boolean hasMilestoneSummaries() {
        return this.milestoneSummaries != null && !(this.milestoneSummaries instanceof SdkAutoConstructList);
    }

    public final List<MilestoneSummary> milestoneSummaries() {
        return this.milestoneSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMilestoneSummaries() ? this.milestoneSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMilestonesResponse)) {
            return false;
        }
        ListMilestonesResponse other = (ListMilestonesResponse)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && this.hasMilestoneSummaries() == other.hasMilestoneSummaries() && Objects.equals(this.milestoneSummaries(), other.milestoneSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMilestonesResponse").add("WorkloadId", (Object)this.workloadId()).add("MilestoneSummaries", this.hasMilestoneSummaries() ? this.milestoneSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "MilestoneSummaries": {
                return Optional.ofNullable(clazz.cast(this.milestoneSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMilestonesResponse, T> g) {
        return obj -> g.apply((ListMilestonesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String workloadId;
        private List<MilestoneSummary> milestoneSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMilestonesResponse model) {
            super(model);
            this.workloadId(model.workloadId);
            this.milestoneSummaries(model.milestoneSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        @Transient
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final List<MilestoneSummary.Builder> getMilestoneSummaries() {
            List<MilestoneSummary.Builder> result = MilestoneSummariesCopier.copyToBuilder(this.milestoneSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMilestoneSummaries(Collection<MilestoneSummary.BuilderImpl> milestoneSummaries) {
            this.milestoneSummaries = MilestoneSummariesCopier.copyFromBuilder(milestoneSummaries);
        }

        @Override
        @Transient
        public final Builder milestoneSummaries(Collection<MilestoneSummary> milestoneSummaries) {
            this.milestoneSummaries = MilestoneSummariesCopier.copy(milestoneSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder milestoneSummaries(MilestoneSummary ... milestoneSummaries) {
            this.milestoneSummaries(Arrays.asList(milestoneSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder milestoneSummaries(Consumer<MilestoneSummary.Builder> ... milestoneSummaries) {
            this.milestoneSummaries(Stream.of(milestoneSummaries).map(c -> (MilestoneSummary)((MilestoneSummary.Builder)MilestoneSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMilestonesResponse build() {
            return new ListMilestonesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMilestonesResponse> {
        public Builder workloadId(String var1);

        public Builder milestoneSummaries(Collection<MilestoneSummary> var1);

        public Builder milestoneSummaries(MilestoneSummary ... var1);

        public Builder milestoneSummaries(Consumer<MilestoneSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

