/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ShareInvitationSummariesCopier {
    static List<ShareInvitationSummary> copy(Collection<ShareInvitationSummary> shareInvitationSummariesParam) {
        if (shareInvitationSummariesParam == null || shareInvitationSummariesParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<ShareInvitationSummary> shareInvitationSummariesParamCopy = new ArrayList<>(shareInvitationSummariesParam);
        return Collections.unmodifiableList(shareInvitationSummariesParamCopy);
    }

    static List<ShareInvitationSummary> copyFromBuilder(
            Collection<? extends ShareInvitationSummary.Builder> shareInvitationSummariesParam) {
        if (shareInvitationSummariesParam == null || shareInvitationSummariesParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(shareInvitationSummariesParam.stream().map(ShareInvitationSummary.Builder::build).collect(toList()));
    }
}
