/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A pillar difference return object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PillarDifference implements SdkPojo, Serializable,
        ToCopyableBuilder<PillarDifference.Builder, PillarDifference> {
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarId").getter(getter(PillarDifference::pillarId)).setter(setter(Builder::pillarId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()).build();

    private static final SdkField<String> DIFFERENCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DifferenceStatus").getter(getter(PillarDifference::differenceStatusAsString))
            .setter(setter(Builder::differenceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DifferenceStatus").build()).build();

    private static final SdkField<List<QuestionDifference>> QUESTION_DIFFERENCES_FIELD = SdkField
            .<List<QuestionDifference>> builder(MarshallingType.LIST)
            .memberName("QuestionDifferences")
            .getter(getter(PillarDifference::questionDifferences))
            .setter(setter(Builder::questionDifferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionDifferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QuestionDifference> builder(MarshallingType.SDK_POJO)
                                            .constructor(QuestionDifference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PILLAR_ID_FIELD,
            DIFFERENCE_STATUS_FIELD, QUESTION_DIFFERENCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pillarId;

    private final String differenceStatus;

    private final List<QuestionDifference> questionDifferences;

    private PillarDifference(BuilderImpl builder) {
        this.pillarId = builder.pillarId;
        this.differenceStatus = builder.differenceStatus;
        this.questionDifferences = builder.questionDifferences;
    }

    /**
     * Returns the value of the PillarId property for this object.
     * 
     * @return The value of the PillarId property for this object.
     */
    public final String pillarId() {
        return pillarId;
    }

    /**
     * <p>
     * Indicates the type of change to the pillar.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #differenceStatus}
     * will return {@link DifferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #differenceStatusAsString}.
     * </p>
     * 
     * @return Indicates the type of change to the pillar.
     * @see DifferenceStatus
     */
    public final DifferenceStatus differenceStatus() {
        return DifferenceStatus.fromValue(differenceStatus);
    }

    /**
     * <p>
     * Indicates the type of change to the pillar.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #differenceStatus}
     * will return {@link DifferenceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #differenceStatusAsString}.
     * </p>
     * 
     * @return Indicates the type of change to the pillar.
     * @see DifferenceStatus
     */
    public final String differenceStatusAsString() {
        return differenceStatus;
    }

    /**
     * Returns true if the QuestionDifferences property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasQuestionDifferences() {
        return questionDifferences != null && !(questionDifferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of question differences.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQuestionDifferences()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of question differences.
     */
    public final List<QuestionDifference> questionDifferences() {
        return questionDifferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(differenceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasQuestionDifferences() ? questionDifferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PillarDifference)) {
            return false;
        }
        PillarDifference other = (PillarDifference) obj;
        return Objects.equals(pillarId(), other.pillarId())
                && Objects.equals(differenceStatusAsString(), other.differenceStatusAsString())
                && hasQuestionDifferences() == other.hasQuestionDifferences()
                && Objects.equals(questionDifferences(), other.questionDifferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PillarDifference").add("PillarId", pillarId())
                .add("DifferenceStatus", differenceStatusAsString())
                .add("QuestionDifferences", hasQuestionDifferences() ? questionDifferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PillarId":
            return Optional.ofNullable(clazz.cast(pillarId()));
        case "DifferenceStatus":
            return Optional.ofNullable(clazz.cast(differenceStatusAsString()));
        case "QuestionDifferences":
            return Optional.ofNullable(clazz.cast(questionDifferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PillarDifference, T> g) {
        return obj -> g.apply((PillarDifference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PillarDifference> {
        /**
         * Sets the value of the PillarId property for this object.
         *
         * @param pillarId
         *        The new value for the PillarId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarId(String pillarId);

        /**
         * <p>
         * Indicates the type of change to the pillar.
         * </p>
         * 
         * @param differenceStatus
         *        Indicates the type of change to the pillar.
         * @see DifferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferenceStatus
         */
        Builder differenceStatus(String differenceStatus);

        /**
         * <p>
         * Indicates the type of change to the pillar.
         * </p>
         * 
         * @param differenceStatus
         *        Indicates the type of change to the pillar.
         * @see DifferenceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferenceStatus
         */
        Builder differenceStatus(DifferenceStatus differenceStatus);

        /**
         * <p>
         * List of question differences.
         * </p>
         * 
         * @param questionDifferences
         *        List of question differences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionDifferences(Collection<QuestionDifference> questionDifferences);

        /**
         * <p>
         * List of question differences.
         * </p>
         * 
         * @param questionDifferences
         *        List of question differences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionDifferences(QuestionDifference... questionDifferences);

        /**
         * <p>
         * List of question differences.
         * </p>
         * This is a convenience that creates an instance of the {@link List<QuestionDifference>.Builder} avoiding the
         * need to create one manually via {@link List<QuestionDifference>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QuestionDifference>.Builder#build()} is called immediately
         * and its result is passed to {@link #questionDifferences(List<QuestionDifference>)}.
         * 
         * @param questionDifferences
         *        a consumer that will call methods on {@link List<QuestionDifference>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #questionDifferences(List<QuestionDifference>)
         */
        Builder questionDifferences(Consumer<QuestionDifference.Builder>... questionDifferences);
    }

    static final class BuilderImpl implements Builder {
        private String pillarId;

        private String differenceStatus;

        private List<QuestionDifference> questionDifferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PillarDifference model) {
            pillarId(model.pillarId);
            differenceStatus(model.differenceStatus);
            questionDifferences(model.questionDifferences);
        }

        public final String getPillarId() {
            return pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        public final String getDifferenceStatus() {
            return differenceStatus;
        }

        @Override
        public final Builder differenceStatus(String differenceStatus) {
            this.differenceStatus = differenceStatus;
            return this;
        }

        @Override
        public final Builder differenceStatus(DifferenceStatus differenceStatus) {
            this.differenceStatus(differenceStatus == null ? null : differenceStatus.toString());
            return this;
        }

        public final void setDifferenceStatus(String differenceStatus) {
            this.differenceStatus = differenceStatus;
        }

        public final Collection<QuestionDifference.Builder> getQuestionDifferences() {
            if (questionDifferences instanceof SdkAutoConstructList) {
                return null;
            }
            return questionDifferences != null ? questionDifferences.stream().map(QuestionDifference::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder questionDifferences(Collection<QuestionDifference> questionDifferences) {
            this.questionDifferences = QuestionDifferencesCopier.copy(questionDifferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder questionDifferences(QuestionDifference... questionDifferences) {
            questionDifferences(Arrays.asList(questionDifferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder questionDifferences(Consumer<QuestionDifference.Builder>... questionDifferences) {
            questionDifferences(Stream.of(questionDifferences).map(c -> QuestionDifference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setQuestionDifferences(Collection<QuestionDifference.BuilderImpl> questionDifferences) {
            this.questionDifferences = QuestionDifferencesCopier.copyFromBuilder(questionDifferences);
        }

        @Override
        public PillarDifference build() {
            return new PillarDifference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
