/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An answer summary of a lens review in a workload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnswerSummary implements SdkPojo, Serializable, ToCopyableBuilder<AnswerSummary.Builder, AnswerSummary> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionId").getter(getter(AnswerSummary::questionId)).setter(setter(Builder::questionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()).build();

    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PillarId").getter(getter(AnswerSummary::pillarId)).setter(setter(Builder::pillarId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()).build();

    private static final SdkField<String> QUESTION_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuestionTitle").getter(getter(AnswerSummary::questionTitle)).setter(setter(Builder::questionTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTitle").build()).build();

    private static final SdkField<List<Choice>> CHOICES_FIELD = SdkField
            .<List<Choice>> builder(MarshallingType.LIST)
            .memberName("Choices")
            .getter(getter(AnswerSummary::choices))
            .setter(setter(Builder::choices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Choices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Choice> builder(MarshallingType.SDK_POJO)
                                            .constructor(Choice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SELECTED_CHOICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelectedChoices")
            .getter(getter(AnswerSummary::selectedChoices))
            .setter(setter(Builder::selectedChoices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_APPLICABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsApplicable").getter(getter(AnswerSummary::isApplicable)).setter(setter(Builder::isApplicable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsApplicable").build()).build();

    private static final SdkField<String> RISK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Risk")
            .getter(getter(AnswerSummary::riskAsString)).setter(setter(Builder::risk))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Risk").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD,
            PILLAR_ID_FIELD, QUESTION_TITLE_FIELD, CHOICES_FIELD, SELECTED_CHOICES_FIELD, IS_APPLICABLE_FIELD, RISK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String questionId;

    private final String pillarId;

    private final String questionTitle;

    private final List<Choice> choices;

    private final List<String> selectedChoices;

    private final Boolean isApplicable;

    private final String risk;

    private AnswerSummary(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.pillarId = builder.pillarId;
        this.questionTitle = builder.questionTitle;
        this.choices = builder.choices;
        this.selectedChoices = builder.selectedChoices;
        this.isApplicable = builder.isApplicable;
        this.risk = builder.risk;
    }

    /**
     * Returns the value of the QuestionId property for this object.
     * 
     * @return The value of the QuestionId property for this object.
     */
    public final String questionId() {
        return questionId;
    }

    /**
     * Returns the value of the PillarId property for this object.
     * 
     * @return The value of the PillarId property for this object.
     */
    public final String pillarId() {
        return pillarId;
    }

    /**
     * Returns the value of the QuestionTitle property for this object.
     * 
     * @return The value of the QuestionTitle property for this object.
     */
    public final String questionTitle() {
        return questionTitle;
    }

    /**
     * Returns true if the Choices property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasChoices() {
        return choices != null && !(choices instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Choices property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChoices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the Choices property for this object.
     */
    public final List<Choice> choices() {
        return choices;
    }

    /**
     * Returns true if the SelectedChoices property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSelectedChoices() {
        return selectedChoices != null && !(selectedChoices instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SelectedChoices property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSelectedChoices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the SelectedChoices property for this object.
     */
    public final List<String> selectedChoices() {
        return selectedChoices;
    }

    /**
     * Returns the value of the IsApplicable property for this object.
     * 
     * @return The value of the IsApplicable property for this object.
     */
    public final Boolean isApplicable() {
        return isApplicable;
    }

    /**
     * Returns the value of the Risk property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #risk} will return
     * {@link Risk#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskAsString}.
     * </p>
     * 
     * @return The value of the Risk property for this object.
     * @see Risk
     */
    public final Risk risk() {
        return Risk.fromValue(risk);
    }

    /**
     * Returns the value of the Risk property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #risk} will return
     * {@link Risk#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #riskAsString}.
     * </p>
     * 
     * @return The value of the Risk property for this object.
     * @see Risk
     */
    public final String riskAsString() {
        return risk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(questionId());
        hashCode = 31 * hashCode + Objects.hashCode(pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(questionTitle());
        hashCode = 31 * hashCode + Objects.hashCode(hasChoices() ? choices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedChoices() ? selectedChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isApplicable());
        hashCode = 31 * hashCode + Objects.hashCode(riskAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnswerSummary)) {
            return false;
        }
        AnswerSummary other = (AnswerSummary) obj;
        return Objects.equals(questionId(), other.questionId()) && Objects.equals(pillarId(), other.pillarId())
                && Objects.equals(questionTitle(), other.questionTitle()) && hasChoices() == other.hasChoices()
                && Objects.equals(choices(), other.choices()) && hasSelectedChoices() == other.hasSelectedChoices()
                && Objects.equals(selectedChoices(), other.selectedChoices())
                && Objects.equals(isApplicable(), other.isApplicable()) && Objects.equals(riskAsString(), other.riskAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnswerSummary").add("QuestionId", questionId()).add("PillarId", pillarId())
                .add("QuestionTitle", questionTitle()).add("Choices", hasChoices() ? choices() : null)
                .add("SelectedChoices", hasSelectedChoices() ? selectedChoices() : null).add("IsApplicable", isApplicable())
                .add("Risk", riskAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuestionId":
            return Optional.ofNullable(clazz.cast(questionId()));
        case "PillarId":
            return Optional.ofNullable(clazz.cast(pillarId()));
        case "QuestionTitle":
            return Optional.ofNullable(clazz.cast(questionTitle()));
        case "Choices":
            return Optional.ofNullable(clazz.cast(choices()));
        case "SelectedChoices":
            return Optional.ofNullable(clazz.cast(selectedChoices()));
        case "IsApplicable":
            return Optional.ofNullable(clazz.cast(isApplicable()));
        case "Risk":
            return Optional.ofNullable(clazz.cast(riskAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnswerSummary, T> g) {
        return obj -> g.apply((AnswerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnswerSummary> {
        /**
         * Sets the value of the QuestionId property for this object.
         *
         * @param questionId
         *        The new value for the QuestionId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionId(String questionId);

        /**
         * Sets the value of the PillarId property for this object.
         *
         * @param pillarId
         *        The new value for the PillarId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarId(String pillarId);

        /**
         * Sets the value of the QuestionTitle property for this object.
         *
         * @param questionTitle
         *        The new value for the QuestionTitle property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder questionTitle(String questionTitle);

        /**
         * Sets the value of the Choices property for this object.
         *
         * @param choices
         *        The new value for the Choices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choices(Collection<Choice> choices);

        /**
         * Sets the value of the Choices property for this object.
         *
         * @param choices
         *        The new value for the Choices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder choices(Choice... choices);

        /**
         * Sets the value of the Choices property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Choice>.Builder} avoiding the need to
         * create one manually via {@link List<Choice>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Choice>.Builder#build()} is called immediately and its
         * result is passed to {@link #choices(List<Choice>)}.
         * 
         * @param choices
         *        a consumer that will call methods on {@link List<Choice>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #choices(List<Choice>)
         */
        Builder choices(Consumer<Choice.Builder>... choices);

        /**
         * Sets the value of the SelectedChoices property for this object.
         *
         * @param selectedChoices
         *        The new value for the SelectedChoices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoices(Collection<String> selectedChoices);

        /**
         * Sets the value of the SelectedChoices property for this object.
         *
         * @param selectedChoices
         *        The new value for the SelectedChoices property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedChoices(String... selectedChoices);

        /**
         * Sets the value of the IsApplicable property for this object.
         *
         * @param isApplicable
         *        The new value for the IsApplicable property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isApplicable(Boolean isApplicable);

        /**
         * Sets the value of the Risk property for this object.
         *
         * @param risk
         *        The new value for the Risk property for this object.
         * @see Risk
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Risk
         */
        Builder risk(String risk);

        /**
         * Sets the value of the Risk property for this object.
         *
         * @param risk
         *        The new value for the Risk property for this object.
         * @see Risk
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Risk
         */
        Builder risk(Risk risk);
    }

    static final class BuilderImpl implements Builder {
        private String questionId;

        private String pillarId;

        private String questionTitle;

        private List<Choice> choices = DefaultSdkAutoConstructList.getInstance();

        private List<String> selectedChoices = DefaultSdkAutoConstructList.getInstance();

        private Boolean isApplicable;

        private String risk;

        private BuilderImpl() {
        }

        private BuilderImpl(AnswerSummary model) {
            questionId(model.questionId);
            pillarId(model.pillarId);
            questionTitle(model.questionTitle);
            choices(model.choices);
            selectedChoices(model.selectedChoices);
            isApplicable(model.isApplicable);
            risk(model.risk);
        }

        public final String getQuestionId() {
            return questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        public final String getPillarId() {
            return pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        public final String getQuestionTitle() {
            return questionTitle;
        }

        @Override
        public final Builder questionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
            return this;
        }

        public final void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        public final Collection<Choice.Builder> getChoices() {
            if (choices instanceof SdkAutoConstructList) {
                return null;
            }
            return choices != null ? choices.stream().map(Choice::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder choices(Collection<Choice> choices) {
            this.choices = ChoicesCopier.copy(choices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choices(Choice... choices) {
            choices(Arrays.asList(choices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choices(Consumer<Choice.Builder>... choices) {
            choices(Stream.of(choices).map(c -> Choice.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChoices(Collection<Choice.BuilderImpl> choices) {
            this.choices = ChoicesCopier.copyFromBuilder(choices);
        }

        public final Collection<String> getSelectedChoices() {
            if (selectedChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedChoices;
        }

        @Override
        public final Builder selectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoices(String... selectedChoices) {
            selectedChoices(Arrays.asList(selectedChoices));
            return this;
        }

        public final void setSelectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
        }

        public final Boolean getIsApplicable() {
            return isApplicable;
        }

        @Override
        public final Builder isApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
            return this;
        }

        public final void setIsApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
        }

        public final String getRisk() {
            return risk;
        }

        @Override
        public final Builder risk(String risk) {
            this.risk = risk;
            return this;
        }

        @Override
        public final Builder risk(Risk risk) {
            this.risk(risk == null ? null : risk.toString());
            return this;
        }

        public final void setRisk(String risk) {
            this.risk = risk;
        }

        @Override
        public AnswerSummary build() {
            return new AnswerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
