/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ShareInvitationSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.ShareInvitationSummary;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListShareInvitationsResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, ListShareInvitationsResponse> {
    private static final SdkField<List<ShareInvitationSummary>> SHARE_INVITATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ShareInvitationSummaries").getter(ListShareInvitationsResponse.getter(ListShareInvitationsResponse::shareInvitationSummaries)).setter(ListShareInvitationsResponse.setter(Builder::shareInvitationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareInvitationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ShareInvitationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListShareInvitationsResponse.getter(ListShareInvitationsResponse::nextToken)).setter(ListShareInvitationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_INVITATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ShareInvitationSummary> shareInvitationSummaries;
    private final String nextToken;

    private ListShareInvitationsResponse(BuilderImpl builder) {
        super(builder);
        this.shareInvitationSummaries = builder.shareInvitationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasShareInvitationSummaries() {
        return this.shareInvitationSummaries != null && !(this.shareInvitationSummaries instanceof SdkAutoConstructList);
    }

    public final List<ShareInvitationSummary> shareInvitationSummaries() {
        return this.shareInvitationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShareInvitationSummaries() ? this.shareInvitationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListShareInvitationsResponse)) {
            return false;
        }
        ListShareInvitationsResponse other = (ListShareInvitationsResponse)((Object)obj);
        return this.hasShareInvitationSummaries() == other.hasShareInvitationSummaries() && Objects.equals(this.shareInvitationSummaries(), other.shareInvitationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListShareInvitationsResponse").add("ShareInvitationSummaries", this.hasShareInvitationSummaries() ? this.shareInvitationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShareInvitationSummaries": {
                return Optional.ofNullable(clazz.cast(this.shareInvitationSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListShareInvitationsResponse, T> g) {
        return obj -> g.apply((ListShareInvitationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private List<ShareInvitationSummary> shareInvitationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListShareInvitationsResponse model) {
            super(model);
            this.shareInvitationSummaries(model.shareInvitationSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<ShareInvitationSummary.Builder> getShareInvitationSummaries() {
            if (this.shareInvitationSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.shareInvitationSummaries != null ? (Collection)this.shareInvitationSummaries.stream().map(ShareInvitationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder shareInvitationSummaries(Collection<ShareInvitationSummary> shareInvitationSummaries) {
            this.shareInvitationSummaries = ShareInvitationSummariesCopier.copy(shareInvitationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareInvitationSummaries(ShareInvitationSummary ... shareInvitationSummaries) {
            this.shareInvitationSummaries(Arrays.asList(shareInvitationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareInvitationSummaries(Consumer<ShareInvitationSummary.Builder> ... shareInvitationSummaries) {
            this.shareInvitationSummaries(Stream.of(shareInvitationSummaries).map(c -> (ShareInvitationSummary)((ShareInvitationSummary.Builder)ShareInvitationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setShareInvitationSummaries(Collection<ShareInvitationSummary.BuilderImpl> shareInvitationSummaries) {
            this.shareInvitationSummaries = ShareInvitationSummariesCopier.copyFromBuilder(shareInvitationSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListShareInvitationsResponse build() {
            return new ListShareInvitationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListShareInvitationsResponse> {
        public Builder shareInvitationSummaries(Collection<ShareInvitationSummary> var1);

        public Builder shareInvitationSummaries(ShareInvitationSummary ... var1);

        public Builder shareInvitationSummaries(Consumer<ShareInvitationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

