/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.LensStatus;
import software.amazon.awssdk.services.wellarchitected.model.PillarReviewSummariesCopier;
import software.amazon.awssdk.services.wellarchitected.model.PillarReviewSummary;
import software.amazon.awssdk.services.wellarchitected.model.Risk;
import software.amazon.awssdk.services.wellarchitected.model.RiskCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LensReview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LensReview> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(LensReview.getter(LensReview::lensAlias)).setter(LensReview.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<String> LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensVersion").getter(LensReview.getter(LensReview::lensVersion)).setter(LensReview.setter(Builder::lensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensVersion").build()}).build();
    private static final SdkField<String> LENS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensName").getter(LensReview.getter(LensReview::lensName)).setter(LensReview.setter(Builder::lensName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensName").build()}).build();
    private static final SdkField<String> LENS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensStatus").getter(LensReview.getter(LensReview::lensStatusAsString)).setter(LensReview.setter(Builder::lensStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensStatus").build()}).build();
    private static final SdkField<List<PillarReviewSummary>> PILLAR_REVIEW_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PillarReviewSummaries").getter(LensReview.getter(LensReview::pillarReviewSummaries)).setter(LensReview.setter(Builder::pillarReviewSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarReviewSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PillarReviewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(LensReview.getter(LensReview::updatedAt)).setter(LensReview.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(LensReview.getter(LensReview::notes)).setter(LensReview.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RiskCounts").getter(LensReview.getter(LensReview::riskCountsAsStrings)).setter(LensReview.setter(Builder::riskCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(LensReview.getter(LensReview::nextToken)).setter(LensReview.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD, LENS_VERSION_FIELD, LENS_NAME_FIELD, LENS_STATUS_FIELD, PILLAR_REVIEW_SUMMARIES_FIELD, UPDATED_AT_FIELD, NOTES_FIELD, RISK_COUNTS_FIELD, NEXT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lensAlias;
    private final String lensVersion;
    private final String lensName;
    private final String lensStatus;
    private final List<PillarReviewSummary> pillarReviewSummaries;
    private final Instant updatedAt;
    private final String notes;
    private final Map<String, Integer> riskCounts;
    private final String nextToken;

    private LensReview(BuilderImpl builder) {
        this.lensAlias = builder.lensAlias;
        this.lensVersion = builder.lensVersion;
        this.lensName = builder.lensName;
        this.lensStatus = builder.lensStatus;
        this.pillarReviewSummaries = builder.pillarReviewSummaries;
        this.updatedAt = builder.updatedAt;
        this.notes = builder.notes;
        this.riskCounts = builder.riskCounts;
        this.nextToken = builder.nextToken;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String lensVersion() {
        return this.lensVersion;
    }

    public final String lensName() {
        return this.lensName;
    }

    public final LensStatus lensStatus() {
        return LensStatus.fromValue(this.lensStatus);
    }

    public final String lensStatusAsString() {
        return this.lensStatus;
    }

    public final boolean hasPillarReviewSummaries() {
        return this.pillarReviewSummaries != null && !(this.pillarReviewSummaries instanceof SdkAutoConstructList);
    }

    public final List<PillarReviewSummary> pillarReviewSummaries() {
        return this.pillarReviewSummaries;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String notes() {
        return this.notes;
    }

    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(this.riskCounts);
    }

    public final boolean hasRiskCounts() {
        return this.riskCounts != null && !(this.riskCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> riskCountsAsStrings() {
        return this.riskCounts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPillarReviewSummaries() ? this.pillarReviewSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRiskCounts() ? this.riskCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensReview)) {
            return false;
        }
        LensReview other = (LensReview)obj;
        return Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.lensVersion(), other.lensVersion()) && Objects.equals(this.lensName(), other.lensName()) && Objects.equals(this.lensStatusAsString(), other.lensStatusAsString()) && this.hasPillarReviewSummaries() == other.hasPillarReviewSummaries() && Objects.equals(this.pillarReviewSummaries(), other.pillarReviewSummaries()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.notes(), other.notes()) && this.hasRiskCounts() == other.hasRiskCounts() && Objects.equals(this.riskCountsAsStrings(), other.riskCountsAsStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"LensReview").add("LensAlias", (Object)this.lensAlias()).add("LensVersion", (Object)this.lensVersion()).add("LensName", (Object)this.lensName()).add("LensStatus", (Object)this.lensStatusAsString()).add("PillarReviewSummaries", this.hasPillarReviewSummaries() ? this.pillarReviewSummaries() : null).add("UpdatedAt", (Object)this.updatedAt()).add("Notes", (Object)this.notes()).add("RiskCounts", this.hasRiskCounts() ? this.riskCountsAsStrings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "LensVersion": {
                return Optional.ofNullable(clazz.cast(this.lensVersion()));
            }
            case "LensName": {
                return Optional.ofNullable(clazz.cast(this.lensName()));
            }
            case "LensStatus": {
                return Optional.ofNullable(clazz.cast(this.lensStatusAsString()));
            }
            case "PillarReviewSummaries": {
                return Optional.ofNullable(clazz.cast(this.pillarReviewSummaries()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "RiskCounts": {
                return Optional.ofNullable(clazz.cast(this.riskCountsAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LensReview, T> g) {
        return obj -> g.apply((LensReview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lensAlias;
        private String lensVersion;
        private String lensName;
        private String lensStatus;
        private List<PillarReviewSummary> pillarReviewSummaries = DefaultSdkAutoConstructList.getInstance();
        private Instant updatedAt;
        private String notes;
        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(LensReview model) {
            this.lensAlias(model.lensAlias);
            this.lensVersion(model.lensVersion);
            this.lensName(model.lensName);
            this.lensStatus(model.lensStatus);
            this.pillarReviewSummaries(model.pillarReviewSummaries);
            this.updatedAt(model.updatedAt);
            this.notes(model.notes);
            this.riskCountsWithStrings(model.riskCounts);
            this.nextToken(model.nextToken);
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        public final String getLensVersion() {
            return this.lensVersion;
        }

        @Override
        public final Builder lensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
            return this;
        }

        public final void setLensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
        }

        public final String getLensName() {
            return this.lensName;
        }

        @Override
        public final Builder lensName(String lensName) {
            this.lensName = lensName;
            return this;
        }

        public final void setLensName(String lensName) {
            this.lensName = lensName;
        }

        public final String getLensStatus() {
            return this.lensStatus;
        }

        @Override
        public final Builder lensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
            return this;
        }

        @Override
        public final Builder lensStatus(LensStatus lensStatus) {
            this.lensStatus(lensStatus == null ? null : lensStatus.toString());
            return this;
        }

        public final void setLensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
        }

        public final List<PillarReviewSummary.Builder> getPillarReviewSummaries() {
            List<PillarReviewSummary.Builder> result = PillarReviewSummariesCopier.copyToBuilder(this.pillarReviewSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder pillarReviewSummaries(Collection<PillarReviewSummary> pillarReviewSummaries) {
            this.pillarReviewSummaries = PillarReviewSummariesCopier.copy(pillarReviewSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarReviewSummaries(PillarReviewSummary ... pillarReviewSummaries) {
            this.pillarReviewSummaries(Arrays.asList(pillarReviewSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarReviewSummaries(Consumer<PillarReviewSummary.Builder> ... pillarReviewSummaries) {
            this.pillarReviewSummaries(Stream.of(pillarReviewSummaries).map(c -> (PillarReviewSummary)((PillarReviewSummary.Builder)PillarReviewSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPillarReviewSummaries(Collection<PillarReviewSummary.BuilderImpl> pillarReviewSummaries) {
            this.pillarReviewSummaries = PillarReviewSummariesCopier.copyFromBuilder(pillarReviewSummaries);
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final String getNotes() {
            return this.notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (this.riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.riskCounts;
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public LensReview build() {
            return new LensReview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LensReview> {
        public Builder lensAlias(String var1);

        public Builder lensVersion(String var1);

        public Builder lensName(String var1);

        public Builder lensStatus(String var1);

        public Builder lensStatus(LensStatus var1);

        public Builder pillarReviewSummaries(Collection<PillarReviewSummary> var1);

        public Builder pillarReviewSummaries(PillarReviewSummary ... var1);

        public Builder pillarReviewSummaries(Consumer<PillarReviewSummary.Builder> ... var1);

        public Builder updatedAt(Instant var1);

        public Builder notes(String var1);

        public Builder riskCountsWithStrings(Map<String, Integer> var1);

        public Builder riskCounts(Map<Risk, Integer> var1);

        public Builder nextToken(String var1);
    }
}

