/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.Choice;
import software.amazon.awssdk.services.wellarchitected.model.ChoicesCopier;
import software.amazon.awssdk.services.wellarchitected.model.Risk;
import software.amazon.awssdk.services.wellarchitected.model.SelectedChoicesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Answer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Answer> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(Answer.getter(Answer::questionId)).setter(Answer.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()}).build();
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarId").getter(Answer.getter(Answer::pillarId)).setter(Answer.setter(Builder::pillarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()}).build();
    private static final SdkField<String> QUESTION_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionTitle").getter(Answer.getter(Answer::questionTitle)).setter(Answer.setter(Builder::questionTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTitle").build()}).build();
    private static final SdkField<String> QUESTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionDescription").getter(Answer.getter(Answer::questionDescription)).setter(Answer.setter(Builder::questionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionDescription").build()}).build();
    private static final SdkField<String> IMPROVEMENT_PLAN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImprovementPlanUrl").getter(Answer.getter(Answer::improvementPlanUrl)).setter(Answer.setter(Builder::improvementPlanUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImprovementPlanUrl").build()}).build();
    private static final SdkField<String> HELPFUL_RESOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HelpfulResourceUrl").getter(Answer.getter(Answer::helpfulResourceUrl)).setter(Answer.setter(Builder::helpfulResourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HelpfulResourceUrl").build()}).build();
    private static final SdkField<List<Choice>> CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Choices").getter(Answer.getter(Answer::choices)).setter(Answer.setter(Builder::choices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Choices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Choice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SELECTED_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedChoices").getter(Answer.getter(Answer::selectedChoices)).setter(Answer.setter(Builder::selectedChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_APPLICABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsApplicable").getter(Answer.getter(Answer::isApplicable)).setter(Answer.setter(Builder::isApplicable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsApplicable").build()}).build();
    private static final SdkField<String> RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Risk").getter(Answer.getter(Answer::riskAsString)).setter(Answer.setter(Builder::risk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Risk").build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(Answer.getter(Answer::notes)).setter(Answer.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD, PILLAR_ID_FIELD, QUESTION_TITLE_FIELD, QUESTION_DESCRIPTION_FIELD, IMPROVEMENT_PLAN_URL_FIELD, HELPFUL_RESOURCE_URL_FIELD, CHOICES_FIELD, SELECTED_CHOICES_FIELD, IS_APPLICABLE_FIELD, RISK_FIELD, NOTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String questionId;
    private final String pillarId;
    private final String questionTitle;
    private final String questionDescription;
    private final String improvementPlanUrl;
    private final String helpfulResourceUrl;
    private final List<Choice> choices;
    private final List<String> selectedChoices;
    private final Boolean isApplicable;
    private final String risk;
    private final String notes;

    private Answer(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.pillarId = builder.pillarId;
        this.questionTitle = builder.questionTitle;
        this.questionDescription = builder.questionDescription;
        this.improvementPlanUrl = builder.improvementPlanUrl;
        this.helpfulResourceUrl = builder.helpfulResourceUrl;
        this.choices = builder.choices;
        this.selectedChoices = builder.selectedChoices;
        this.isApplicable = builder.isApplicable;
        this.risk = builder.risk;
        this.notes = builder.notes;
    }

    public final String questionId() {
        return this.questionId;
    }

    public final String pillarId() {
        return this.pillarId;
    }

    public final String questionTitle() {
        return this.questionTitle;
    }

    public final String questionDescription() {
        return this.questionDescription;
    }

    public final String improvementPlanUrl() {
        return this.improvementPlanUrl;
    }

    public final String helpfulResourceUrl() {
        return this.helpfulResourceUrl;
    }

    public final boolean hasChoices() {
        return this.choices != null && !(this.choices instanceof SdkAutoConstructList);
    }

    public final List<Choice> choices() {
        return this.choices;
    }

    public final boolean hasSelectedChoices() {
        return this.selectedChoices != null && !(this.selectedChoices instanceof SdkAutoConstructList);
    }

    public final List<String> selectedChoices() {
        return this.selectedChoices;
    }

    public final Boolean isApplicable() {
        return this.isApplicable;
    }

    public final Risk risk() {
        return Risk.fromValue(this.risk);
    }

    public final String riskAsString() {
        return this.risk;
    }

    public final String notes() {
        return this.notes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.improvementPlanUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.helpfulResourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChoices() ? this.choices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedChoices() ? this.selectedChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isApplicable());
        hashCode = 31 * hashCode + Objects.hashCode(this.riskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Answer)) {
            return false;
        }
        Answer other = (Answer)obj;
        return Objects.equals(this.questionId(), other.questionId()) && Objects.equals(this.pillarId(), other.pillarId()) && Objects.equals(this.questionTitle(), other.questionTitle()) && Objects.equals(this.questionDescription(), other.questionDescription()) && Objects.equals(this.improvementPlanUrl(), other.improvementPlanUrl()) && Objects.equals(this.helpfulResourceUrl(), other.helpfulResourceUrl()) && this.hasChoices() == other.hasChoices() && Objects.equals(this.choices(), other.choices()) && this.hasSelectedChoices() == other.hasSelectedChoices() && Objects.equals(this.selectedChoices(), other.selectedChoices()) && Objects.equals(this.isApplicable(), other.isApplicable()) && Objects.equals(this.riskAsString(), other.riskAsString()) && Objects.equals(this.notes(), other.notes());
    }

    public final String toString() {
        return ToString.builder((String)"Answer").add("QuestionId", (Object)this.questionId()).add("PillarId", (Object)this.pillarId()).add("QuestionTitle", (Object)this.questionTitle()).add("QuestionDescription", (Object)this.questionDescription()).add("ImprovementPlanUrl", (Object)this.improvementPlanUrl()).add("HelpfulResourceUrl", (Object)this.helpfulResourceUrl()).add("Choices", this.hasChoices() ? this.choices() : null).add("SelectedChoices", this.hasSelectedChoices() ? this.selectedChoices() : null).add("IsApplicable", (Object)this.isApplicable()).add("Risk", (Object)this.riskAsString()).add("Notes", (Object)this.notes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "PillarId": {
                return Optional.ofNullable(clazz.cast(this.pillarId()));
            }
            case "QuestionTitle": {
                return Optional.ofNullable(clazz.cast(this.questionTitle()));
            }
            case "QuestionDescription": {
                return Optional.ofNullable(clazz.cast(this.questionDescription()));
            }
            case "ImprovementPlanUrl": {
                return Optional.ofNullable(clazz.cast(this.improvementPlanUrl()));
            }
            case "HelpfulResourceUrl": {
                return Optional.ofNullable(clazz.cast(this.helpfulResourceUrl()));
            }
            case "Choices": {
                return Optional.ofNullable(clazz.cast(this.choices()));
            }
            case "SelectedChoices": {
                return Optional.ofNullable(clazz.cast(this.selectedChoices()));
            }
            case "IsApplicable": {
                return Optional.ofNullable(clazz.cast(this.isApplicable()));
            }
            case "Risk": {
                return Optional.ofNullable(clazz.cast(this.riskAsString()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Answer, T> g) {
        return obj -> g.apply((Answer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String questionId;
        private String pillarId;
        private String questionTitle;
        private String questionDescription;
        private String improvementPlanUrl;
        private String helpfulResourceUrl;
        private List<Choice> choices = DefaultSdkAutoConstructList.getInstance();
        private List<String> selectedChoices = DefaultSdkAutoConstructList.getInstance();
        private Boolean isApplicable;
        private String risk;
        private String notes;

        private BuilderImpl() {
        }

        private BuilderImpl(Answer model) {
            this.questionId(model.questionId);
            this.pillarId(model.pillarId);
            this.questionTitle(model.questionTitle);
            this.questionDescription(model.questionDescription);
            this.improvementPlanUrl(model.improvementPlanUrl);
            this.helpfulResourceUrl(model.helpfulResourceUrl);
            this.choices(model.choices);
            this.selectedChoices(model.selectedChoices);
            this.isApplicable(model.isApplicable);
            this.risk(model.risk);
            this.notes(model.notes);
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        public final String getPillarId() {
            return this.pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        public final String getQuestionTitle() {
            return this.questionTitle;
        }

        @Override
        public final Builder questionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
            return this;
        }

        public final void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        public final String getQuestionDescription() {
            return this.questionDescription;
        }

        @Override
        public final Builder questionDescription(String questionDescription) {
            this.questionDescription = questionDescription;
            return this;
        }

        public final void setQuestionDescription(String questionDescription) {
            this.questionDescription = questionDescription;
        }

        public final String getImprovementPlanUrl() {
            return this.improvementPlanUrl;
        }

        @Override
        public final Builder improvementPlanUrl(String improvementPlanUrl) {
            this.improvementPlanUrl = improvementPlanUrl;
            return this;
        }

        public final void setImprovementPlanUrl(String improvementPlanUrl) {
            this.improvementPlanUrl = improvementPlanUrl;
        }

        public final String getHelpfulResourceUrl() {
            return this.helpfulResourceUrl;
        }

        @Override
        public final Builder helpfulResourceUrl(String helpfulResourceUrl) {
            this.helpfulResourceUrl = helpfulResourceUrl;
            return this;
        }

        public final void setHelpfulResourceUrl(String helpfulResourceUrl) {
            this.helpfulResourceUrl = helpfulResourceUrl;
        }

        public final List<Choice.Builder> getChoices() {
            List<Choice.Builder> result = ChoicesCopier.copyToBuilder(this.choices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder choices(Collection<Choice> choices) {
            this.choices = ChoicesCopier.copy(choices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choices(Choice ... choices) {
            this.choices(Arrays.asList(choices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder choices(Consumer<Choice.Builder> ... choices) {
            this.choices(Stream.of(choices).map(c -> (Choice)((Choice.Builder)Choice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChoices(Collection<Choice.BuilderImpl> choices) {
            this.choices = ChoicesCopier.copyFromBuilder(choices);
        }

        public final Collection<String> getSelectedChoices() {
            if (this.selectedChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedChoices;
        }

        @Override
        public final Builder selectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoices(String ... selectedChoices) {
            this.selectedChoices(Arrays.asList(selectedChoices));
            return this;
        }

        public final void setSelectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
        }

        public final Boolean getIsApplicable() {
            return this.isApplicable;
        }

        @Override
        public final Builder isApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
            return this;
        }

        public final void setIsApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
        }

        public final String getRisk() {
            return this.risk;
        }

        @Override
        public final Builder risk(String risk) {
            this.risk = risk;
            return this;
        }

        @Override
        public final Builder risk(Risk risk) {
            this.risk(risk == null ? null : risk.toString());
            return this;
        }

        public final void setRisk(String risk) {
            this.risk = risk;
        }

        public final String getNotes() {
            return this.notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        public Answer build() {
            return new Answer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Answer> {
        public Builder questionId(String var1);

        public Builder pillarId(String var1);

        public Builder questionTitle(String var1);

        public Builder questionDescription(String var1);

        public Builder improvementPlanUrl(String var1);

        public Builder helpfulResourceUrl(String var1);

        public Builder choices(Collection<Choice> var1);

        public Builder choices(Choice ... var1);

        public Builder choices(Consumer<Choice.Builder> ... var1);

        public Builder selectedChoices(Collection<String> var1);

        public Builder selectedChoices(String ... var1);

        public Builder isApplicable(Boolean var1);

        public Builder risk(String var1);

        public Builder risk(Risk var1);

        public Builder notes(String var1);
    }
}

