/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.wellarchitected.WellArchitectedClient;
import software.amazon.awssdk.services.wellarchitected.model.ListLensesRequest;
import software.amazon.awssdk.services.wellarchitected.model.ListLensesResponse;

public class ListLensesIterable
implements SdkIterable<ListLensesResponse> {
    private final WellArchitectedClient client;
    private final ListLensesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLensesIterable(WellArchitectedClient client, ListLensesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListLensesResponseFetcher();
    }

    public Iterator<ListLensesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLensesResponseFetcher
    implements SyncPageFetcher<ListLensesResponse> {
        private ListLensesResponseFetcher() {
        }

        public boolean hasNextPage(ListLensesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLensesResponse nextPage(ListLensesResponse previousPage) {
            if (previousPage == null) {
                return ListLensesIterable.this.client.listLenses(ListLensesIterable.this.firstRequest);
            }
            return ListLensesIterable.this.client.listLenses((ListLensesRequest)((Object)ListLensesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

