/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.LensUpgradeSummary;
import software.amazon.awssdk.services.wellarchitected.model.NotificationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationSummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(NotificationSummary.getter(NotificationSummary::typeAsString)).setter(NotificationSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<LensUpgradeSummary> LENS_UPGRADE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LensUpgradeSummary").getter(NotificationSummary.getter(NotificationSummary::lensUpgradeSummary)).setter(NotificationSummary.setter(Builder::lensUpgradeSummary)).constructor(LensUpgradeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensUpgradeSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LENS_UPGRADE_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final LensUpgradeSummary lensUpgradeSummary;

    private NotificationSummary(BuilderImpl builder) {
        this.type = builder.type;
        this.lensUpgradeSummary = builder.lensUpgradeSummary;
    }

    public final NotificationType type() {
        return NotificationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final LensUpgradeSummary lensUpgradeSummary() {
        return this.lensUpgradeSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensUpgradeSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationSummary)) {
            return false;
        }
        NotificationSummary other = (NotificationSummary)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.lensUpgradeSummary(), other.lensUpgradeSummary());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationSummary").add("Type", (Object)this.typeAsString()).add("LensUpgradeSummary", (Object)this.lensUpgradeSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "LensUpgradeSummary": {
                return Optional.ofNullable(clazz.cast(this.lensUpgradeSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationSummary, T> g) {
        return obj -> g.apply((NotificationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private LensUpgradeSummary lensUpgradeSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationSummary model) {
            this.type(model.type);
            this.lensUpgradeSummary(model.lensUpgradeSummary);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NotificationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final LensUpgradeSummary.Builder getLensUpgradeSummary() {
            return this.lensUpgradeSummary != null ? this.lensUpgradeSummary.toBuilder() : null;
        }

        @Override
        public final Builder lensUpgradeSummary(LensUpgradeSummary lensUpgradeSummary) {
            this.lensUpgradeSummary = lensUpgradeSummary;
            return this;
        }

        public final void setLensUpgradeSummary(LensUpgradeSummary.BuilderImpl lensUpgradeSummary) {
            this.lensUpgradeSummary = lensUpgradeSummary != null ? lensUpgradeSummary.build() : null;
        }

        public NotificationSummary build() {
            return new NotificationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationSummary> {
        public Builder type(String var1);

        public Builder type(NotificationType var1);

        public Builder lensUpgradeSummary(LensUpgradeSummary var1);

        default public Builder lensUpgradeSummary(Consumer<LensUpgradeSummary.Builder> lensUpgradeSummary) {
            return this.lensUpgradeSummary((LensUpgradeSummary)((LensUpgradeSummary.Builder)LensUpgradeSummary.builder().applyMutation(lensUpgradeSummary)).build());
        }
    }
}

