/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.SelectedChoicesCopier;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAnswerRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, UpdateAnswerRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::workloadId)).setter(UpdateAnswerRequest.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::lensAlias)).setter(UpdateAnswerRequest.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()}).build();
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::questionId)).setter(UpdateAnswerRequest.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("QuestionId").build()}).build();
    private static final SdkField<List<String>> SELECTED_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedChoices").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::selectedChoices)).setter(UpdateAnswerRequest.setter(Builder::selectedChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedChoices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Notes").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::notes)).setter(UpdateAnswerRequest.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build()}).build();
    private static final SdkField<Boolean> IS_APPLICABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsApplicable").getter(UpdateAnswerRequest.getter(UpdateAnswerRequest::isApplicable)).setter(UpdateAnswerRequest.setter(Builder::isApplicable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsApplicable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, LENS_ALIAS_FIELD, QUESTION_ID_FIELD, SELECTED_CHOICES_FIELD, NOTES_FIELD, IS_APPLICABLE_FIELD));
    private final String workloadId;
    private final String lensAlias;
    private final String questionId;
    private final List<String> selectedChoices;
    private final String notes;
    private final Boolean isApplicable;

    private UpdateAnswerRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.lensAlias = builder.lensAlias;
        this.questionId = builder.questionId;
        this.selectedChoices = builder.selectedChoices;
        this.notes = builder.notes;
        this.isApplicable = builder.isApplicable;
    }

    public String workloadId() {
        return this.workloadId;
    }

    public String lensAlias() {
        return this.lensAlias;
    }

    public String questionId() {
        return this.questionId;
    }

    public boolean hasSelectedChoices() {
        return this.selectedChoices != null && !(this.selectedChoices instanceof SdkAutoConstructList);
    }

    public List<String> selectedChoices() {
        return this.selectedChoices;
    }

    public String notes() {
        return this.notes;
    }

    public Boolean isApplicable() {
        return this.isApplicable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedChoices() ? this.selectedChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.notes());
        hashCode = 31 * hashCode + Objects.hashCode(this.isApplicable());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnswerRequest)) {
            return false;
        }
        UpdateAnswerRequest other = (UpdateAnswerRequest)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.questionId(), other.questionId()) && this.hasSelectedChoices() == other.hasSelectedChoices() && Objects.equals(this.selectedChoices(), other.selectedChoices()) && Objects.equals(this.notes(), other.notes()) && Objects.equals(this.isApplicable(), other.isApplicable());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAnswerRequest").add("WorkloadId", (Object)this.workloadId()).add("LensAlias", (Object)this.lensAlias()).add("QuestionId", (Object)this.questionId()).add("SelectedChoices", this.hasSelectedChoices() ? this.selectedChoices() : null).add("Notes", (Object)this.notes()).add("IsApplicable", (Object)this.isApplicable()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "SelectedChoices": {
                return Optional.ofNullable(clazz.cast(this.selectedChoices()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
            case "IsApplicable": {
                return Optional.ofNullable(clazz.cast(this.isApplicable()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnswerRequest, T> g) {
        return obj -> g.apply((UpdateAnswerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String workloadId;
        private String lensAlias;
        private String questionId;
        private List<String> selectedChoices = DefaultSdkAutoConstructList.getInstance();
        private String notes;
        private Boolean isApplicable;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnswerRequest model) {
            super(model);
            this.workloadId(model.workloadId);
            this.lensAlias(model.lensAlias);
            this.questionId(model.questionId);
            this.selectedChoices(model.selectedChoices);
            this.notes(model.notes);
            this.isApplicable(model.isApplicable);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        public final Collection<String> getSelectedChoices() {
            if (this.selectedChoices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedChoices;
        }

        @Override
        public final Builder selectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedChoices(String ... selectedChoices) {
            this.selectedChoices(Arrays.asList(selectedChoices));
            return this;
        }

        public final void setSelectedChoices(Collection<String> selectedChoices) {
            this.selectedChoices = SelectedChoicesCopier.copy(selectedChoices);
        }

        public final String getNotes() {
            return this.notes;
        }

        @Override
        public final Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        public final void setNotes(String notes) {
            this.notes = notes;
        }

        public final Boolean getIsApplicable() {
            return this.isApplicable;
        }

        @Override
        public final Builder isApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
            return this;
        }

        public final void setIsApplicable(Boolean isApplicable) {
            this.isApplicable = isApplicable;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnswerRequest build() {
            return new UpdateAnswerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAnswerRequest> {
        public Builder workloadId(String var1);

        public Builder lensAlias(String var1);

        public Builder questionId(String var1);

        public Builder selectedChoices(Collection<String> var1);

        public Builder selectedChoices(String ... var1);

        public Builder notes(String var1);

        public Builder isApplicable(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

