/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.DifferenceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuestionDifference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuestionDifference> {
    private static final SdkField<String> QUESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionId").getter(QuestionDifference.getter(QuestionDifference::questionId)).setter(QuestionDifference.setter(Builder::questionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionId").build()}).build();
    private static final SdkField<String> QUESTION_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuestionTitle").getter(QuestionDifference.getter(QuestionDifference::questionTitle)).setter(QuestionDifference.setter(Builder::questionTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuestionTitle").build()}).build();
    private static final SdkField<String> DIFFERENCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DifferenceStatus").getter(QuestionDifference.getter(QuestionDifference::differenceStatusAsString)).setter(QuestionDifference.setter(Builder::differenceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DifferenceStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUESTION_ID_FIELD, QUESTION_TITLE_FIELD, DIFFERENCE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String questionId;
    private final String questionTitle;
    private final String differenceStatus;

    private QuestionDifference(BuilderImpl builder) {
        this.questionId = builder.questionId;
        this.questionTitle = builder.questionTitle;
        this.differenceStatus = builder.differenceStatus;
    }

    public String questionId() {
        return this.questionId;
    }

    public String questionTitle() {
        return this.questionTitle;
    }

    public DifferenceStatus differenceStatus() {
        return DifferenceStatus.fromValue(this.differenceStatus);
    }

    public String differenceStatusAsString() {
        return this.differenceStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.questionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.questionTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.differenceStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuestionDifference)) {
            return false;
        }
        QuestionDifference other = (QuestionDifference)obj;
        return Objects.equals(this.questionId(), other.questionId()) && Objects.equals(this.questionTitle(), other.questionTitle()) && Objects.equals(this.differenceStatusAsString(), other.differenceStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"QuestionDifference").add("QuestionId", (Object)this.questionId()).add("QuestionTitle", (Object)this.questionTitle()).add("DifferenceStatus", (Object)this.differenceStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuestionId": {
                return Optional.ofNullable(clazz.cast(this.questionId()));
            }
            case "QuestionTitle": {
                return Optional.ofNullable(clazz.cast(this.questionTitle()));
            }
            case "DifferenceStatus": {
                return Optional.ofNullable(clazz.cast(this.differenceStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuestionDifference, T> g) {
        return obj -> g.apply((QuestionDifference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String questionId;
        private String questionTitle;
        private String differenceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(QuestionDifference model) {
            this.questionId(model.questionId);
            this.questionTitle(model.questionTitle);
            this.differenceStatus(model.differenceStatus);
        }

        public final String getQuestionId() {
            return this.questionId;
        }

        @Override
        public final Builder questionId(String questionId) {
            this.questionId = questionId;
            return this;
        }

        public final void setQuestionId(String questionId) {
            this.questionId = questionId;
        }

        public final String getQuestionTitle() {
            return this.questionTitle;
        }

        @Override
        public final Builder questionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
            return this;
        }

        public final void setQuestionTitle(String questionTitle) {
            this.questionTitle = questionTitle;
        }

        public final String getDifferenceStatus() {
            return this.differenceStatus;
        }

        @Override
        public final Builder differenceStatus(String differenceStatus) {
            this.differenceStatus = differenceStatus;
            return this;
        }

        @Override
        public final Builder differenceStatus(DifferenceStatus differenceStatus) {
            this.differenceStatus(differenceStatus == null ? null : differenceStatus.toString());
            return this;
        }

        public final void setDifferenceStatus(String differenceStatus) {
            this.differenceStatus = differenceStatus;
        }

        public QuestionDifference build() {
            return new QuestionDifference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuestionDifference> {
        public Builder questionId(String var1);

        public Builder questionTitle(String var1);

        public Builder differenceStatus(String var1);

        public Builder differenceStatus(DifferenceStatus var1);
    }
}

