/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.VersionDifferences;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLensVersionDifferenceResponse
extends WellArchitectedResponse
implements ToCopyableBuilder<Builder, GetLensVersionDifferenceResponse> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(GetLensVersionDifferenceResponse.getter(GetLensVersionDifferenceResponse::lensAlias)).setter(GetLensVersionDifferenceResponse.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<String> BASE_LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseLensVersion").getter(GetLensVersionDifferenceResponse.getter(GetLensVersionDifferenceResponse::baseLensVersion)).setter(GetLensVersionDifferenceResponse.setter(Builder::baseLensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseLensVersion").build()}).build();
    private static final SdkField<String> LATEST_LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestLensVersion").getter(GetLensVersionDifferenceResponse.getter(GetLensVersionDifferenceResponse::latestLensVersion)).setter(GetLensVersionDifferenceResponse.setter(Builder::latestLensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestLensVersion").build()}).build();
    private static final SdkField<VersionDifferences> VERSION_DIFFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VersionDifferences").getter(GetLensVersionDifferenceResponse.getter(GetLensVersionDifferenceResponse::versionDifferences)).setter(GetLensVersionDifferenceResponse.setter(Builder::versionDifferences)).constructor(VersionDifferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDifferences").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD, BASE_LENS_VERSION_FIELD, LATEST_LENS_VERSION_FIELD, VERSION_DIFFERENCES_FIELD));
    private final String lensAlias;
    private final String baseLensVersion;
    private final String latestLensVersion;
    private final VersionDifferences versionDifferences;

    private GetLensVersionDifferenceResponse(BuilderImpl builder) {
        super(builder);
        this.lensAlias = builder.lensAlias;
        this.baseLensVersion = builder.baseLensVersion;
        this.latestLensVersion = builder.latestLensVersion;
        this.versionDifferences = builder.versionDifferences;
    }

    public String lensAlias() {
        return this.lensAlias;
    }

    public String baseLensVersion() {
        return this.baseLensVersion;
    }

    public String latestLensVersion() {
        return this.latestLensVersion;
    }

    public VersionDifferences versionDifferences() {
        return this.versionDifferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestLensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDifferences());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLensVersionDifferenceResponse)) {
            return false;
        }
        GetLensVersionDifferenceResponse other = (GetLensVersionDifferenceResponse)((Object)obj);
        return Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.baseLensVersion(), other.baseLensVersion()) && Objects.equals(this.latestLensVersion(), other.latestLensVersion()) && Objects.equals(this.versionDifferences(), other.versionDifferences());
    }

    public String toString() {
        return ToString.builder((String)"GetLensVersionDifferenceResponse").add("LensAlias", (Object)this.lensAlias()).add("BaseLensVersion", (Object)this.baseLensVersion()).add("LatestLensVersion", (Object)this.latestLensVersion()).add("VersionDifferences", (Object)this.versionDifferences()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "BaseLensVersion": {
                return Optional.ofNullable(clazz.cast(this.baseLensVersion()));
            }
            case "LatestLensVersion": {
                return Optional.ofNullable(clazz.cast(this.latestLensVersion()));
            }
            case "VersionDifferences": {
                return Optional.ofNullable(clazz.cast(this.versionDifferences()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLensVersionDifferenceResponse, T> g) {
        return obj -> g.apply((GetLensVersionDifferenceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedResponse.BuilderImpl
    implements Builder {
        private String lensAlias;
        private String baseLensVersion;
        private String latestLensVersion;
        private VersionDifferences versionDifferences;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLensVersionDifferenceResponse model) {
            super(model);
            this.lensAlias(model.lensAlias);
            this.baseLensVersion(model.baseLensVersion);
            this.latestLensVersion(model.latestLensVersion);
            this.versionDifferences(model.versionDifferences);
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        public final String getBaseLensVersion() {
            return this.baseLensVersion;
        }

        @Override
        public final Builder baseLensVersion(String baseLensVersion) {
            this.baseLensVersion = baseLensVersion;
            return this;
        }

        public final void setBaseLensVersion(String baseLensVersion) {
            this.baseLensVersion = baseLensVersion;
        }

        public final String getLatestLensVersion() {
            return this.latestLensVersion;
        }

        @Override
        public final Builder latestLensVersion(String latestLensVersion) {
            this.latestLensVersion = latestLensVersion;
            return this;
        }

        public final void setLatestLensVersion(String latestLensVersion) {
            this.latestLensVersion = latestLensVersion;
        }

        public final VersionDifferences.Builder getVersionDifferences() {
            return this.versionDifferences != null ? this.versionDifferences.toBuilder() : null;
        }

        @Override
        public final Builder versionDifferences(VersionDifferences versionDifferences) {
            this.versionDifferences = versionDifferences;
            return this;
        }

        public final void setVersionDifferences(VersionDifferences.BuilderImpl versionDifferences) {
            this.versionDifferences = versionDifferences != null ? versionDifferences.build() : null;
        }

        @Override
        public GetLensVersionDifferenceResponse build() {
            return new GetLensVersionDifferenceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLensVersionDifferenceResponse> {
        public Builder lensAlias(String var1);

        public Builder baseLensVersion(String var1);

        public Builder latestLensVersion(String var1);

        public Builder versionDifferences(VersionDifferences var1);

        default public Builder versionDifferences(Consumer<VersionDifferences.Builder> versionDifferences) {
            return this.versionDifferences((VersionDifferences)((VersionDifferences.Builder)VersionDifferences.builder().applyMutation(versionDifferences)).build());
        }
    }
}

