/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLensVersionDifferenceRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, GetLensVersionDifferenceRequest> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(GetLensVersionDifferenceRequest.getter(GetLensVersionDifferenceRequest::lensAlias)).setter(GetLensVersionDifferenceRequest.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("LensAlias").build()}).build();
    private static final SdkField<String> BASE_LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseLensVersion").getter(GetLensVersionDifferenceRequest.getter(GetLensVersionDifferenceRequest::baseLensVersion)).setter(GetLensVersionDifferenceRequest.setter(Builder::baseLensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("BaseLensVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD, BASE_LENS_VERSION_FIELD));
    private final String lensAlias;
    private final String baseLensVersion;

    private GetLensVersionDifferenceRequest(BuilderImpl builder) {
        super(builder);
        this.lensAlias = builder.lensAlias;
        this.baseLensVersion = builder.baseLensVersion;
    }

    public String lensAlias() {
        return this.lensAlias;
    }

    public String baseLensVersion() {
        return this.baseLensVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseLensVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLensVersionDifferenceRequest)) {
            return false;
        }
        GetLensVersionDifferenceRequest other = (GetLensVersionDifferenceRequest)((Object)obj);
        return Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.baseLensVersion(), other.baseLensVersion());
    }

    public String toString() {
        return ToString.builder((String)"GetLensVersionDifferenceRequest").add("LensAlias", (Object)this.lensAlias()).add("BaseLensVersion", (Object)this.baseLensVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "BaseLensVersion": {
                return Optional.ofNullable(clazz.cast(this.baseLensVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLensVersionDifferenceRequest, T> g) {
        return obj -> g.apply((GetLensVersionDifferenceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String lensAlias;
        private String baseLensVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLensVersionDifferenceRequest model) {
            super(model);
            this.lensAlias(model.lensAlias);
            this.baseLensVersion(model.baseLensVersion);
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        public final String getBaseLensVersion() {
            return this.baseLensVersion;
        }

        @Override
        public final Builder baseLensVersion(String baseLensVersion) {
            this.baseLensVersion = baseLensVersion;
            return this;
        }

        public final void setBaseLensVersion(String baseLensVersion) {
            this.baseLensVersion = baseLensVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLensVersionDifferenceRequest build() {
            return new GetLensVersionDifferenceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLensVersionDifferenceRequest> {
        public Builder lensAlias(String var1);

        public Builder baseLensVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

