/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.FallbackBehavior;
import software.amazon.awssdk.services.wafv2.model.ForwardedIPPosition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IPSetForwardedIPConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IPSetForwardedIPConfig> {
    private static final SdkField<String> HEADER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HeaderName").getter(IPSetForwardedIPConfig.getter(IPSetForwardedIPConfig::headerName)).setter(IPSetForwardedIPConfig.setter(Builder::headerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderName").build()}).build();
    private static final SdkField<String> FALLBACK_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FallbackBehavior").getter(IPSetForwardedIPConfig.getter(IPSetForwardedIPConfig::fallbackBehaviorAsString)).setter(IPSetForwardedIPConfig.setter(Builder::fallbackBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FallbackBehavior").build()}).build();
    private static final SdkField<String> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Position").getter(IPSetForwardedIPConfig.getter(IPSetForwardedIPConfig::positionAsString)).setter(IPSetForwardedIPConfig.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_NAME_FIELD, FALLBACK_BEHAVIOR_FIELD, POSITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IPSetForwardedIPConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String headerName;
    private final String fallbackBehavior;
    private final String position;

    private IPSetForwardedIPConfig(BuilderImpl builder) {
        this.headerName = builder.headerName;
        this.fallbackBehavior = builder.fallbackBehavior;
        this.position = builder.position;
    }

    public final String headerName() {
        return this.headerName;
    }

    public final FallbackBehavior fallbackBehavior() {
        return FallbackBehavior.fromValue(this.fallbackBehavior);
    }

    public final String fallbackBehaviorAsString() {
        return this.fallbackBehavior;
    }

    public final ForwardedIPPosition position() {
        return ForwardedIPPosition.fromValue(this.position);
    }

    public final String positionAsString() {
        return this.position;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.headerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fallbackBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.positionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPSetForwardedIPConfig)) {
            return false;
        }
        IPSetForwardedIPConfig other = (IPSetForwardedIPConfig)obj;
        return Objects.equals(this.headerName(), other.headerName()) && Objects.equals(this.fallbackBehaviorAsString(), other.fallbackBehaviorAsString()) && Objects.equals(this.positionAsString(), other.positionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IPSetForwardedIPConfig").add("HeaderName", (Object)this.headerName()).add("FallbackBehavior", (Object)this.fallbackBehaviorAsString()).add("Position", (Object)this.positionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HeaderName": {
                return Optional.ofNullable(clazz.cast(this.headerName()));
            }
            case "FallbackBehavior": {
                return Optional.ofNullable(clazz.cast(this.fallbackBehaviorAsString()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.positionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("HeaderName", HEADER_NAME_FIELD);
        map.put("FallbackBehavior", FALLBACK_BEHAVIOR_FIELD);
        map.put("Position", POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IPSetForwardedIPConfig, T> g) {
        return obj -> g.apply((IPSetForwardedIPConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String headerName;
        private String fallbackBehavior;
        private String position;

        private BuilderImpl() {
        }

        private BuilderImpl(IPSetForwardedIPConfig model) {
            this.headerName(model.headerName);
            this.fallbackBehavior(model.fallbackBehavior);
            this.position(model.position);
        }

        public final String getHeaderName() {
            return this.headerName;
        }

        public final void setHeaderName(String headerName) {
            this.headerName = headerName;
        }

        @Override
        public final Builder headerName(String headerName) {
            this.headerName = headerName;
            return this;
        }

        public final String getFallbackBehavior() {
            return this.fallbackBehavior;
        }

        public final void setFallbackBehavior(String fallbackBehavior) {
            this.fallbackBehavior = fallbackBehavior;
        }

        @Override
        public final Builder fallbackBehavior(String fallbackBehavior) {
            this.fallbackBehavior = fallbackBehavior;
            return this;
        }

        @Override
        public final Builder fallbackBehavior(FallbackBehavior fallbackBehavior) {
            this.fallbackBehavior(fallbackBehavior == null ? null : fallbackBehavior.toString());
            return this;
        }

        public final String getPosition() {
            return this.position;
        }

        public final void setPosition(String position) {
            this.position = position;
        }

        @Override
        public final Builder position(String position) {
            this.position = position;
            return this;
        }

        @Override
        public final Builder position(ForwardedIPPosition position) {
            this.position(position == null ? null : position.toString());
            return this;
        }

        public IPSetForwardedIPConfig build() {
            return new IPSetForwardedIPConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IPSetForwardedIPConfig> {
        public Builder headerName(String var1);

        public Builder fallbackBehavior(String var1);

        public Builder fallbackBehavior(FallbackBehavior var1);

        public Builder position(String var1);

        public Builder position(ForwardedIPPosition var1);
    }
}

