/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of a managed product, such as an Amazon Web Services Managed Rules rule group or an Amazon Web
 * Services Marketplace managed rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedProductDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedProductDescriptor.Builder, ManagedProductDescriptor> {
    private static final SdkField<String> VENDOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VendorName").getter(getter(ManagedProductDescriptor::vendorName)).setter(setter(Builder::vendorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendorName").build()).build();

    private static final SdkField<String> MANAGED_RULE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedRuleSetName").getter(getter(ManagedProductDescriptor::managedRuleSetName))
            .setter(setter(Builder::managedRuleSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedRuleSetName").build())
            .build();

    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductId").getter(getter(ManagedProductDescriptor::productId)).setter(setter(Builder::productId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()).build();

    private static final SdkField<String> PRODUCT_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductLink").getter(getter(ManagedProductDescriptor::productLink)).setter(setter(Builder::productLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductLink").build()).build();

    private static final SdkField<String> PRODUCT_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductTitle").getter(getter(ManagedProductDescriptor::productTitle))
            .setter(setter(Builder::productTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductTitle").build()).build();

    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductDescription").getter(getter(ManagedProductDescriptor::productDescription))
            .setter(setter(Builder::productDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build())
            .build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(ManagedProductDescriptor::snsTopicArn)).setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<Boolean> IS_VERSIONING_SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsVersioningSupported").getter(getter(ManagedProductDescriptor::isVersioningSupported))
            .setter(setter(Builder::isVersioningSupported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsVersioningSupported").build())
            .build();

    private static final SdkField<Boolean> IS_ADVANCED_MANAGED_RULE_SET_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("IsAdvancedManagedRuleSet")
            .getter(getter(ManagedProductDescriptor::isAdvancedManagedRuleSet)).setter(setter(Builder::isAdvancedManagedRuleSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAdvancedManagedRuleSet").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VENDOR_NAME_FIELD,
            MANAGED_RULE_SET_NAME_FIELD, PRODUCT_ID_FIELD, PRODUCT_LINK_FIELD, PRODUCT_TITLE_FIELD, PRODUCT_DESCRIPTION_FIELD,
            SNS_TOPIC_ARN_FIELD, IS_VERSIONING_SUPPORTED_FIELD, IS_ADVANCED_MANAGED_RULE_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vendorName;

    private final String managedRuleSetName;

    private final String productId;

    private final String productLink;

    private final String productTitle;

    private final String productDescription;

    private final String snsTopicArn;

    private final Boolean isVersioningSupported;

    private final Boolean isAdvancedManagedRuleSet;

    private ManagedProductDescriptor(BuilderImpl builder) {
        this.vendorName = builder.vendorName;
        this.managedRuleSetName = builder.managedRuleSetName;
        this.productId = builder.productId;
        this.productLink = builder.productLink;
        this.productTitle = builder.productTitle;
        this.productDescription = builder.productDescription;
        this.snsTopicArn = builder.snsTopicArn;
        this.isVersioningSupported = builder.isVersioningSupported;
        this.isAdvancedManagedRuleSet = builder.isAdvancedManagedRuleSet;
    }

    /**
     * <p>
     * The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule
     * group.
     * </p>
     * 
     * @return The name of the managed rule group vendor. You use this, along with the rule group name, to identify a
     *         rule group.
     */
    public final String vendorName() {
        return vendorName;
    }

    /**
     * <p>
     * The name of the managed rule group. For example, <code>AWSManagedRulesAnonymousIpList</code> or
     * <code>AWSManagedRulesATPRuleSet</code>.
     * </p>
     * 
     * @return The name of the managed rule group. For example, <code>AWSManagedRulesAnonymousIpList</code> or
     *         <code>AWSManagedRulesATPRuleSet</code>.
     */
    public final String managedRuleSetName() {
        return managedRuleSetName;
    }

    /**
     * <p>
     * A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You
     * provide it to operations like update and delete.
     * </p>
     * 
     * @return A unique identifier for the rule group. This ID is returned in the responses to create and list commands.
     *         You provide it to operations like update and delete.
     */
    public final String productId() {
        return productId;
    }

    /**
     * <p>
     * For Amazon Web Services Marketplace managed rule groups only, the link to the rule group product page.
     * </p>
     * 
     * @return For Amazon Web Services Marketplace managed rule groups only, the link to the rule group product page.
     */
    public final String productLink() {
        return productLink;
    }

    /**
     * <p>
     * The display name for the managed rule group. For example, <code>Anonymous IP list</code> or
     * <code>Account takeover prevention</code>.
     * </p>
     * 
     * @return The display name for the managed rule group. For example, <code>Anonymous IP list</code> or
     *         <code>Account takeover prevention</code>.
     */
    public final String productTitle() {
        return productTitle;
    }

    /**
     * <p>
     * A short description of the managed rule group.
     * </p>
     * 
     * @return A short description of the managed rule group.
     */
    public final String productDescription() {
        return productDescription;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to provide
     * notification of changes to the managed rule group. You can subscribe to the SNS topic to receive notifications
     * when the managed rule group is modified, such as for new versions and for version expiration. For more
     * information, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple Notification
     * Service Developer Guide</a>.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to provide
     *         notification of changes to the managed rule group. You can subscribe to the SNS topic to receive
     *         notifications when the managed rule group is modified, such as for new versions and for version
     *         expiration. For more information, see the <a
     *         href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple Notification Service
     *         Developer Guide</a>.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * <p>
     * Indicates whether the rule group is versioned.
     * </p>
     * 
     * @return Indicates whether the rule group is versioned.
     */
    public final Boolean isVersioningSupported() {
        return isVersioningSupported;
    }

    /**
     * <p>
     * Indicates whether the rule group provides an advanced set of protections, such as the the Amazon Web Services
     * Managed Rules rule groups that are used for WAF intelligent threat mitigation.
     * </p>
     * 
     * @return Indicates whether the rule group provides an advanced set of protections, such as the the Amazon Web
     *         Services Managed Rules rule groups that are used for WAF intelligent threat mitigation.
     */
    public final Boolean isAdvancedManagedRuleSet() {
        return isAdvancedManagedRuleSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vendorName());
        hashCode = 31 * hashCode + Objects.hashCode(managedRuleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(productId());
        hashCode = 31 * hashCode + Objects.hashCode(productLink());
        hashCode = 31 * hashCode + Objects.hashCode(productTitle());
        hashCode = 31 * hashCode + Objects.hashCode(productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(isVersioningSupported());
        hashCode = 31 * hashCode + Objects.hashCode(isAdvancedManagedRuleSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedProductDescriptor)) {
            return false;
        }
        ManagedProductDescriptor other = (ManagedProductDescriptor) obj;
        return Objects.equals(vendorName(), other.vendorName())
                && Objects.equals(managedRuleSetName(), other.managedRuleSetName())
                && Objects.equals(productId(), other.productId()) && Objects.equals(productLink(), other.productLink())
                && Objects.equals(productTitle(), other.productTitle())
                && Objects.equals(productDescription(), other.productDescription())
                && Objects.equals(snsTopicArn(), other.snsTopicArn())
                && Objects.equals(isVersioningSupported(), other.isVersioningSupported())
                && Objects.equals(isAdvancedManagedRuleSet(), other.isAdvancedManagedRuleSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedProductDescriptor").add("VendorName", vendorName())
                .add("ManagedRuleSetName", managedRuleSetName()).add("ProductId", productId()).add("ProductLink", productLink())
                .add("ProductTitle", productTitle()).add("ProductDescription", productDescription())
                .add("SnsTopicArn", snsTopicArn()).add("IsVersioningSupported", isVersioningSupported())
                .add("IsAdvancedManagedRuleSet", isAdvancedManagedRuleSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VendorName":
            return Optional.ofNullable(clazz.cast(vendorName()));
        case "ManagedRuleSetName":
            return Optional.ofNullable(clazz.cast(managedRuleSetName()));
        case "ProductId":
            return Optional.ofNullable(clazz.cast(productId()));
        case "ProductLink":
            return Optional.ofNullable(clazz.cast(productLink()));
        case "ProductTitle":
            return Optional.ofNullable(clazz.cast(productTitle()));
        case "ProductDescription":
            return Optional.ofNullable(clazz.cast(productDescription()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "IsVersioningSupported":
            return Optional.ofNullable(clazz.cast(isVersioningSupported()));
        case "IsAdvancedManagedRuleSet":
            return Optional.ofNullable(clazz.cast(isAdvancedManagedRuleSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VendorName", VENDOR_NAME_FIELD);
        map.put("ManagedRuleSetName", MANAGED_RULE_SET_NAME_FIELD);
        map.put("ProductId", PRODUCT_ID_FIELD);
        map.put("ProductLink", PRODUCT_LINK_FIELD);
        map.put("ProductTitle", PRODUCT_TITLE_FIELD);
        map.put("ProductDescription", PRODUCT_DESCRIPTION_FIELD);
        map.put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
        map.put("IsVersioningSupported", IS_VERSIONING_SUPPORTED_FIELD);
        map.put("IsAdvancedManagedRuleSet", IS_ADVANCED_MANAGED_RULE_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedProductDescriptor, T> g) {
        return obj -> g.apply((ManagedProductDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedProductDescriptor> {
        /**
         * <p>
         * The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule
         * group.
         * </p>
         * 
         * @param vendorName
         *        The name of the managed rule group vendor. You use this, along with the rule group name, to identify a
         *        rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorName(String vendorName);

        /**
         * <p>
         * The name of the managed rule group. For example, <code>AWSManagedRulesAnonymousIpList</code> or
         * <code>AWSManagedRulesATPRuleSet</code>.
         * </p>
         * 
         * @param managedRuleSetName
         *        The name of the managed rule group. For example, <code>AWSManagedRulesAnonymousIpList</code> or
         *        <code>AWSManagedRulesATPRuleSet</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedRuleSetName(String managedRuleSetName);

        /**
         * <p>
         * A unique identifier for the rule group. This ID is returned in the responses to create and list commands. You
         * provide it to operations like update and delete.
         * </p>
         * 
         * @param productId
         *        A unique identifier for the rule group. This ID is returned in the responses to create and list
         *        commands. You provide it to operations like update and delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productId(String productId);

        /**
         * <p>
         * For Amazon Web Services Marketplace managed rule groups only, the link to the rule group product page.
         * </p>
         * 
         * @param productLink
         *        For Amazon Web Services Marketplace managed rule groups only, the link to the rule group product page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productLink(String productLink);

        /**
         * <p>
         * The display name for the managed rule group. For example, <code>Anonymous IP list</code> or
         * <code>Account takeover prevention</code>.
         * </p>
         * 
         * @param productTitle
         *        The display name for the managed rule group. For example, <code>Anonymous IP list</code> or
         *        <code>Account takeover prevention</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productTitle(String productTitle);

        /**
         * <p>
         * A short description of the managed rule group.
         * </p>
         * 
         * @param productDescription
         *        A short description of the managed rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to provide
         * notification of changes to the managed rule group. You can subscribe to the SNS topic to receive
         * notifications when the managed rule group is modified, such as for new versions and for version expiration.
         * For more information, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple
         * Notification Service Developer Guide</a>.
         * </p>
         * 
         * @param snsTopicArn
         *        The Amazon resource name (ARN) of the Amazon Simple Notification Service SNS topic that's used to
         *        provide notification of changes to the managed rule group. You can subscribe to the SNS topic to
         *        receive notifications when the managed rule group is modified, such as for new versions and for
         *        version expiration. For more information, see the <a
         *        href="https://docs.aws.amazon.com/sns/latest/dg/welcome.html">Amazon Simple Notification Service
         *        Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * Indicates whether the rule group is versioned.
         * </p>
         * 
         * @param isVersioningSupported
         *        Indicates whether the rule group is versioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isVersioningSupported(Boolean isVersioningSupported);

        /**
         * <p>
         * Indicates whether the rule group provides an advanced set of protections, such as the the Amazon Web Services
         * Managed Rules rule groups that are used for WAF intelligent threat mitigation.
         * </p>
         * 
         * @param isAdvancedManagedRuleSet
         *        Indicates whether the rule group provides an advanced set of protections, such as the the Amazon Web
         *        Services Managed Rules rule groups that are used for WAF intelligent threat mitigation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAdvancedManagedRuleSet(Boolean isAdvancedManagedRuleSet);
    }

    static final class BuilderImpl implements Builder {
        private String vendorName;

        private String managedRuleSetName;

        private String productId;

        private String productLink;

        private String productTitle;

        private String productDescription;

        private String snsTopicArn;

        private Boolean isVersioningSupported;

        private Boolean isAdvancedManagedRuleSet;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedProductDescriptor model) {
            vendorName(model.vendorName);
            managedRuleSetName(model.managedRuleSetName);
            productId(model.productId);
            productLink(model.productLink);
            productTitle(model.productTitle);
            productDescription(model.productDescription);
            snsTopicArn(model.snsTopicArn);
            isVersioningSupported(model.isVersioningSupported);
            isAdvancedManagedRuleSet(model.isAdvancedManagedRuleSet);
        }

        public final String getVendorName() {
            return vendorName;
        }

        public final void setVendorName(String vendorName) {
            this.vendorName = vendorName;
        }

        @Override
        public final Builder vendorName(String vendorName) {
            this.vendorName = vendorName;
            return this;
        }

        public final String getManagedRuleSetName() {
            return managedRuleSetName;
        }

        public final void setManagedRuleSetName(String managedRuleSetName) {
            this.managedRuleSetName = managedRuleSetName;
        }

        @Override
        public final Builder managedRuleSetName(String managedRuleSetName) {
            this.managedRuleSetName = managedRuleSetName;
            return this;
        }

        public final String getProductId() {
            return productId;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final String getProductLink() {
            return productLink;
        }

        public final void setProductLink(String productLink) {
            this.productLink = productLink;
        }

        @Override
        public final Builder productLink(String productLink) {
            this.productLink = productLink;
            return this;
        }

        public final String getProductTitle() {
            return productTitle;
        }

        public final void setProductTitle(String productTitle) {
            this.productTitle = productTitle;
        }

        @Override
        public final Builder productTitle(String productTitle) {
            this.productTitle = productTitle;
            return this;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final Boolean getIsVersioningSupported() {
            return isVersioningSupported;
        }

        public final void setIsVersioningSupported(Boolean isVersioningSupported) {
            this.isVersioningSupported = isVersioningSupported;
        }

        @Override
        public final Builder isVersioningSupported(Boolean isVersioningSupported) {
            this.isVersioningSupported = isVersioningSupported;
            return this;
        }

        public final Boolean getIsAdvancedManagedRuleSet() {
            return isAdvancedManagedRuleSet;
        }

        public final void setIsAdvancedManagedRuleSet(Boolean isAdvancedManagedRuleSet) {
            this.isAdvancedManagedRuleSet = isAdvancedManagedRuleSet;
        }

        @Override
        public final Builder isAdvancedManagedRuleSet(Boolean isAdvancedManagedRuleSet) {
            this.isAdvancedManagedRuleSet = isAdvancedManagedRuleSet;
            return this;
        }

        @Override
        public ManagedProductDescriptor build() {
            return new ManagedProductDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
