/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single action condition for a <a>Condition</a> in a logging filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionCondition implements SdkPojo, Serializable, ToCopyableBuilder<ActionCondition.Builder, ActionCondition> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(ActionCondition::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private ActionCondition(BuilderImpl builder) {
        this.action = builder.action;
    }

    /**
     * <p>
     * The action setting that a log record must contain in order to meet the condition. This is the action that WAF
     * applied to the web request.
     * </p>
     * <p>
     * For rule groups, this is either the configured rule action setting, or if you've applied a rule action override
     * to the rule, it's the override action. The value <code>EXCLUDED_AS_COUNT</code> matches on excluded rules and
     * also on rules that have a rule action override of Count.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ActionValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action setting that a log record must contain in order to meet the condition. This is the action that
     *         WAF applied to the web request. </p>
     *         <p>
     *         For rule groups, this is either the configured rule action setting, or if you've applied a rule action
     *         override to the rule, it's the override action. The value <code>EXCLUDED_AS_COUNT</code> matches on
     *         excluded rules and also on rules that have a rule action override of Count.
     * @see ActionValue
     */
    public final ActionValue action() {
        return ActionValue.fromValue(action);
    }

    /**
     * <p>
     * The action setting that a log record must contain in order to meet the condition. This is the action that WAF
     * applied to the web request.
     * </p>
     * <p>
     * For rule groups, this is either the configured rule action setting, or if you've applied a rule action override
     * to the rule, it's the override action. The value <code>EXCLUDED_AS_COUNT</code> matches on excluded rules and
     * also on rules that have a rule action override of Count.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ActionValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action setting that a log record must contain in order to meet the condition. This is the action that
     *         WAF applied to the web request. </p>
     *         <p>
     *         For rule groups, this is either the configured rule action setting, or if you've applied a rule action
     *         override to the rule, it's the override action. The value <code>EXCLUDED_AS_COUNT</code> matches on
     *         excluded rules and also on rules that have a rule action override of Count.
     * @see ActionValue
     */
    public final String actionAsString() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionCondition)) {
            return false;
        }
        ActionCondition other = (ActionCondition) obj;
        return Objects.equals(actionAsString(), other.actionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionCondition").add("Action", actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Action", ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionCondition, T> g) {
        return obj -> g.apply((ActionCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionCondition> {
        /**
         * <p>
         * The action setting that a log record must contain in order to meet the condition. This is the action that WAF
         * applied to the web request.
         * </p>
         * <p>
         * For rule groups, this is either the configured rule action setting, or if you've applied a rule action
         * override to the rule, it's the override action. The value <code>EXCLUDED_AS_COUNT</code> matches on excluded
         * rules and also on rules that have a rule action override of Count.
         * </p>
         * 
         * @param action
         *        The action setting that a log record must contain in order to meet the condition. This is the action
         *        that WAF applied to the web request. </p>
         *        <p>
         *        For rule groups, this is either the configured rule action setting, or if you've applied a rule action
         *        override to the rule, it's the override action. The value <code>EXCLUDED_AS_COUNT</code> matches on
         *        excluded rules and also on rules that have a rule action override of Count.
         * @see ActionValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionValue
         */
        Builder action(String action);

        /**
         * <p>
         * The action setting that a log record must contain in order to meet the condition. This is the action that WAF
         * applied to the web request.
         * </p>
         * <p>
         * For rule groups, this is either the configured rule action setting, or if you've applied a rule action
         * override to the rule, it's the override action. The value <code>EXCLUDED_AS_COUNT</code> matches on excluded
         * rules and also on rules that have a rule action override of Count.
         * </p>
         * 
         * @param action
         *        The action setting that a log record must contain in order to meet the condition. This is the action
         *        that WAF applied to the web request. </p>
         *        <p>
         *        For rule groups, this is either the configured rule action setting, or if you've applied a rule action
         *        override to the rule, it's the override action. The value <code>EXCLUDED_AS_COUNT</code> matches on
         *        excluded rules and also on rules that have a rule action override of Count.
         * @see ActionValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionValue
         */
        Builder action(ActionValue action);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionCondition model) {
            action(model.action);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ActionValue action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        @Override
        public ActionCondition build() {
            return new ActionCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
