/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.Scope;
import software.amazon.awssdk.services.wafv2.model.Wafv2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRuleGroupRequest
extends Wafv2Request
implements ToCopyableBuilder<Builder, GetRuleGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetRuleGroupRequest.getter(GetRuleGroupRequest::name)).setter(GetRuleGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(GetRuleGroupRequest.getter(GetRuleGroupRequest::scopeAsString)).setter(GetRuleGroupRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetRuleGroupRequest.getter(GetRuleGroupRequest::id)).setter(GetRuleGroupRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(GetRuleGroupRequest.getter(GetRuleGroupRequest::arn)).setter(GetRuleGroupRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SCOPE_FIELD, ID_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRuleGroupRequest.memberNameToFieldInitializer();
    private final String name;
    private final String scope;
    private final String id;
    private final String arn;

    private GetRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.scope = builder.scope;
        this.id = builder.id;
        this.arn = builder.arn;
    }

    public final String name() {
        return this.name;
    }

    public final Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRuleGroupRequest)) {
            return false;
        }
        GetRuleGroupRequest other = (GetRuleGroupRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"GetRuleGroupRequest").add("Name", (Object)this.name()).add("Scope", (Object)this.scopeAsString()).add("Id", (Object)this.id()).add("ARN", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Name", NAME_FIELD);
        map.put("Scope", SCOPE_FIELD);
        map.put("Id", ID_FIELD);
        map.put("ARN", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRuleGroupRequest, T> g) {
        return obj -> g.apply((GetRuleGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Request.BuilderImpl
    implements Builder {
        private String name;
        private String scope;
        private String id;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRuleGroupRequest model) {
            super(model);
            this.name(model.name);
            this.scope(model.scope);
            this.id(model.id);
            this.arn(model.arn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRuleGroupRequest build() {
            return new GetRuleGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Wafv2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRuleGroupRequest> {
        public Builder name(String var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

