/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.CountryCode;
import software.amazon.awssdk.services.wafv2.model.CountryCodesCopier;
import software.amazon.awssdk.services.wafv2.model.ForwardedIPConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoMatchStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeoMatchStatement> {
    private static final SdkField<List<String>> COUNTRY_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CountryCodes").getter(GeoMatchStatement.getter(GeoMatchStatement::countryCodesAsStrings)).setter(GeoMatchStatement.setter(Builder::countryCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ForwardedIPConfig> FORWARDED_IP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForwardedIPConfig").getter(GeoMatchStatement.getter(GeoMatchStatement::forwardedIPConfig)).setter(GeoMatchStatement.setter(Builder::forwardedIPConfig)).constructor(ForwardedIPConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardedIPConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_CODES_FIELD, FORWARDED_IP_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeoMatchStatement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> countryCodes;
    private final ForwardedIPConfig forwardedIPConfig;

    private GeoMatchStatement(BuilderImpl builder) {
        this.countryCodes = builder.countryCodes;
        this.forwardedIPConfig = builder.forwardedIPConfig;
    }

    public final List<CountryCode> countryCodes() {
        return CountryCodesCopier.copyStringToEnum(this.countryCodes);
    }

    public final boolean hasCountryCodes() {
        return this.countryCodes != null && !(this.countryCodes instanceof SdkAutoConstructList);
    }

    public final List<String> countryCodesAsStrings() {
        return this.countryCodes;
    }

    public final ForwardedIPConfig forwardedIPConfig() {
        return this.forwardedIPConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCountryCodes() ? this.countryCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardedIPConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMatchStatement)) {
            return false;
        }
        GeoMatchStatement other = (GeoMatchStatement)obj;
        return this.hasCountryCodes() == other.hasCountryCodes() && Objects.equals(this.countryCodesAsStrings(), other.countryCodesAsStrings()) && Objects.equals(this.forwardedIPConfig(), other.forwardedIPConfig());
    }

    public final String toString() {
        return ToString.builder((String)"GeoMatchStatement").add("CountryCodes", this.hasCountryCodes() ? this.countryCodesAsStrings() : null).add("ForwardedIPConfig", (Object)this.forwardedIPConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CountryCodes": {
                return Optional.ofNullable(clazz.cast(this.countryCodesAsStrings()));
            }
            case "ForwardedIPConfig": {
                return Optional.ofNullable(clazz.cast(this.forwardedIPConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CountryCodes", COUNTRY_CODES_FIELD);
        map.put("ForwardedIPConfig", FORWARDED_IP_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeoMatchStatement, T> g) {
        return obj -> g.apply((GeoMatchStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> countryCodes = DefaultSdkAutoConstructList.getInstance();
        private ForwardedIPConfig forwardedIPConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoMatchStatement model) {
            this.countryCodesWithStrings(model.countryCodes);
            this.forwardedIPConfig(model.forwardedIPConfig);
        }

        public final Collection<String> getCountryCodes() {
            if (this.countryCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.countryCodes;
        }

        public final void setCountryCodes(Collection<String> countryCodes) {
            this.countryCodes = CountryCodesCopier.copy(countryCodes);
        }

        @Override
        public final Builder countryCodesWithStrings(Collection<String> countryCodes) {
            this.countryCodes = CountryCodesCopier.copy(countryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countryCodesWithStrings(String ... countryCodes) {
            this.countryCodesWithStrings(Arrays.asList(countryCodes));
            return this;
        }

        @Override
        public final Builder countryCodes(Collection<CountryCode> countryCodes) {
            this.countryCodes = CountryCodesCopier.copyEnumToString(countryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder countryCodes(CountryCode ... countryCodes) {
            this.countryCodes(Arrays.asList(countryCodes));
            return this;
        }

        public final ForwardedIPConfig.Builder getForwardedIPConfig() {
            return this.forwardedIPConfig != null ? this.forwardedIPConfig.toBuilder() : null;
        }

        public final void setForwardedIPConfig(ForwardedIPConfig.BuilderImpl forwardedIPConfig) {
            this.forwardedIPConfig = forwardedIPConfig != null ? forwardedIPConfig.build() : null;
        }

        @Override
        public final Builder forwardedIPConfig(ForwardedIPConfig forwardedIPConfig) {
            this.forwardedIPConfig = forwardedIPConfig;
            return this;
        }

        public GeoMatchStatement build() {
            return new GeoMatchStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeoMatchStatement> {
        public Builder countryCodesWithStrings(Collection<String> var1);

        public Builder countryCodesWithStrings(String ... var1);

        public Builder countryCodes(Collection<CountryCode> var1);

        public Builder countryCodes(CountryCode ... var1);

        public Builder forwardedIPConfig(ForwardedIPConfig var1);

        default public Builder forwardedIPConfig(Consumer<ForwardedIPConfig.Builder> forwardedIPConfig) {
            return this.forwardedIPConfig((ForwardedIPConfig)((ForwardedIPConfig.Builder)ForwardedIPConfig.builder().applyMutation(forwardedIPConfig)).build());
        }
    }
}

