/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.AsnListCopier;
import software.amazon.awssdk.services.wafv2.model.ForwardedIPConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AsnMatchStatement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AsnMatchStatement> {
    private static final SdkField<List<Long>> ASN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AsnList").getter(AsnMatchStatement.getter(AsnMatchStatement::asnList)).setter(AsnMatchStatement.setter(Builder::asnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ForwardedIPConfig> FORWARDED_IP_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForwardedIPConfig").getter(AsnMatchStatement.getter(AsnMatchStatement::forwardedIPConfig)).setter(AsnMatchStatement.setter(Builder::forwardedIPConfig)).constructor(ForwardedIPConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardedIPConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASN_LIST_FIELD, FORWARDED_IP_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AsnMatchStatement.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Long> asnList;
    private final ForwardedIPConfig forwardedIPConfig;

    private AsnMatchStatement(BuilderImpl builder) {
        this.asnList = builder.asnList;
        this.forwardedIPConfig = builder.forwardedIPConfig;
    }

    public final boolean hasAsnList() {
        return this.asnList != null && !(this.asnList instanceof SdkAutoConstructList);
    }

    public final List<Long> asnList() {
        return this.asnList;
    }

    public final ForwardedIPConfig forwardedIPConfig() {
        return this.forwardedIPConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAsnList() ? this.asnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardedIPConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsnMatchStatement)) {
            return false;
        }
        AsnMatchStatement other = (AsnMatchStatement)obj;
        return this.hasAsnList() == other.hasAsnList() && Objects.equals(this.asnList(), other.asnList()) && Objects.equals(this.forwardedIPConfig(), other.forwardedIPConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AsnMatchStatement").add("AsnList", this.hasAsnList() ? this.asnList() : null).add("ForwardedIPConfig", (Object)this.forwardedIPConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AsnList": {
                return Optional.ofNullable(clazz.cast(this.asnList()));
            }
            case "ForwardedIPConfig": {
                return Optional.ofNullable(clazz.cast(this.forwardedIPConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AsnList", ASN_LIST_FIELD);
        map.put("ForwardedIPConfig", FORWARDED_IP_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AsnMatchStatement, T> g) {
        return obj -> g.apply((AsnMatchStatement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Long> asnList = DefaultSdkAutoConstructList.getInstance();
        private ForwardedIPConfig forwardedIPConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AsnMatchStatement model) {
            this.asnList(model.asnList);
            this.forwardedIPConfig(model.forwardedIPConfig);
        }

        public final Collection<Long> getAsnList() {
            if (this.asnList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.asnList;
        }

        public final void setAsnList(Collection<Long> asnList) {
            this.asnList = AsnListCopier.copy(asnList);
        }

        @Override
        public final Builder asnList(Collection<Long> asnList) {
            this.asnList = AsnListCopier.copy(asnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asnList(Long ... asnList) {
            this.asnList(Arrays.asList(asnList));
            return this;
        }

        public final ForwardedIPConfig.Builder getForwardedIPConfig() {
            return this.forwardedIPConfig != null ? this.forwardedIPConfig.toBuilder() : null;
        }

        public final void setForwardedIPConfig(ForwardedIPConfig.BuilderImpl forwardedIPConfig) {
            this.forwardedIPConfig = forwardedIPConfig != null ? forwardedIPConfig.build() : null;
        }

        @Override
        public final Builder forwardedIPConfig(ForwardedIPConfig forwardedIPConfig) {
            this.forwardedIPConfig = forwardedIPConfig;
            return this;
        }

        public AsnMatchStatement build() {
            return new AsnMatchStatement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AsnMatchStatement> {
        public Builder asnList(Collection<Long> var1);

        public Builder asnList(Long ... var1);

        public Builder forwardedIPConfig(ForwardedIPConfig var1);

        default public Builder forwardedIPConfig(Consumer<ForwardedIPConfig.Builder> forwardedIPConfig) {
            return this.forwardedIPConfig((ForwardedIPConfig)((ForwardedIPConfig.Builder)ForwardedIPConfig.builder().applyMutation(forwardedIPConfig)).build());
        }
    }
}

