/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.TokenDomainsCopier;
import software.amazon.awssdk.services.wafv2.model.Wafv2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDecryptedApiKeyResponse
extends Wafv2Response
implements ToCopyableBuilder<Builder, GetDecryptedApiKeyResponse> {
    private static final SdkField<List<String>> TOKEN_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TokenDomains").getter(GetDecryptedApiKeyResponse.getter(GetDecryptedApiKeyResponse::tokenDomains)).setter(GetDecryptedApiKeyResponse.setter(Builder::tokenDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TokenDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimestamp").getter(GetDecryptedApiKeyResponse.getter(GetDecryptedApiKeyResponse::creationTimestamp)).setter(GetDecryptedApiKeyResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_DOMAINS_FIELD, CREATION_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDecryptedApiKeyResponse.memberNameToFieldInitializer();
    private final List<String> tokenDomains;
    private final Instant creationTimestamp;

    private GetDecryptedApiKeyResponse(BuilderImpl builder) {
        super(builder);
        this.tokenDomains = builder.tokenDomains;
        this.creationTimestamp = builder.creationTimestamp;
    }

    public final boolean hasTokenDomains() {
        return this.tokenDomains != null && !(this.tokenDomains instanceof SdkAutoConstructList);
    }

    public final List<String> tokenDomains() {
        return this.tokenDomains;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTokenDomains() ? this.tokenDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDecryptedApiKeyResponse)) {
            return false;
        }
        GetDecryptedApiKeyResponse other = (GetDecryptedApiKeyResponse)((Object)obj);
        return this.hasTokenDomains() == other.hasTokenDomains() && Objects.equals(this.tokenDomains(), other.tokenDomains()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetDecryptedApiKeyResponse").add("TokenDomains", this.hasTokenDomains() ? this.tokenDomains() : null).add("CreationTimestamp", (Object)this.creationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TokenDomains": {
                return Optional.ofNullable(clazz.cast(this.tokenDomains()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TokenDomains", TOKEN_DOMAINS_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDecryptedApiKeyResponse, T> g) {
        return obj -> g.apply((GetDecryptedApiKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Wafv2Response.BuilderImpl
    implements Builder {
        private List<String> tokenDomains = DefaultSdkAutoConstructList.getInstance();
        private Instant creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDecryptedApiKeyResponse model) {
            super(model);
            this.tokenDomains(model.tokenDomains);
            this.creationTimestamp(model.creationTimestamp);
        }

        public final Collection<String> getTokenDomains() {
            if (this.tokenDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tokenDomains;
        }

        public final void setTokenDomains(Collection<String> tokenDomains) {
            this.tokenDomains = TokenDomainsCopier.copy(tokenDomains);
        }

        @Override
        public final Builder tokenDomains(Collection<String> tokenDomains) {
            this.tokenDomains = TokenDomainsCopier.copy(tokenDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenDomains(String ... tokenDomains) {
            this.tokenDomains(Arrays.asList(tokenDomains));
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        public GetDecryptedApiKeyResponse build() {
            return new GetDecryptedApiKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Wafv2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDecryptedApiKeyResponse> {
        public Builder tokenDomains(Collection<String> var1);

        public Builder tokenDomains(String ... var1);

        public Builder creationTimestamp(Instant var1);
    }
}

