/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.CookieMatchPattern;
import software.amazon.awssdk.services.wafv2.model.MapMatchScope;
import software.amazon.awssdk.services.wafv2.model.OversizeHandling;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cookies
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cookies> {
    private static final SdkField<CookieMatchPattern> MATCH_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MatchPattern").getter(Cookies.getter(Cookies::matchPattern)).setter(Cookies.setter(Builder::matchPattern)).constructor(CookieMatchPattern::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchPattern").build()}).build();
    private static final SdkField<String> MATCH_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchScope").getter(Cookies.getter(Cookies::matchScopeAsString)).setter(Cookies.setter(Builder::matchScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchScope").build()}).build();
    private static final SdkField<String> OVERSIZE_HANDLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OversizeHandling").getter(Cookies.getter(Cookies::oversizeHandlingAsString)).setter(Cookies.setter(Builder::oversizeHandling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OversizeHandling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_PATTERN_FIELD, MATCH_SCOPE_FIELD, OVERSIZE_HANDLING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Cookies.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CookieMatchPattern matchPattern;
    private final String matchScope;
    private final String oversizeHandling;

    private Cookies(BuilderImpl builder) {
        this.matchPattern = builder.matchPattern;
        this.matchScope = builder.matchScope;
        this.oversizeHandling = builder.oversizeHandling;
    }

    public final CookieMatchPattern matchPattern() {
        return this.matchPattern;
    }

    public final MapMatchScope matchScope() {
        return MapMatchScope.fromValue(this.matchScope);
    }

    public final String matchScopeAsString() {
        return this.matchScope;
    }

    public final OversizeHandling oversizeHandling() {
        return OversizeHandling.fromValue(this.oversizeHandling);
    }

    public final String oversizeHandlingAsString() {
        return this.oversizeHandling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.matchPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.oversizeHandlingAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cookies)) {
            return false;
        }
        Cookies other = (Cookies)obj;
        return Objects.equals(this.matchPattern(), other.matchPattern()) && Objects.equals(this.matchScopeAsString(), other.matchScopeAsString()) && Objects.equals(this.oversizeHandlingAsString(), other.oversizeHandlingAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Cookies").add("MatchPattern", (Object)this.matchPattern()).add("MatchScope", (Object)this.matchScopeAsString()).add("OversizeHandling", (Object)this.oversizeHandlingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchPattern": {
                return Optional.ofNullable(clazz.cast(this.matchPattern()));
            }
            case "MatchScope": {
                return Optional.ofNullable(clazz.cast(this.matchScopeAsString()));
            }
            case "OversizeHandling": {
                return Optional.ofNullable(clazz.cast(this.oversizeHandlingAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MatchPattern", MATCH_PATTERN_FIELD);
        map.put("MatchScope", MATCH_SCOPE_FIELD);
        map.put("OversizeHandling", OVERSIZE_HANDLING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Cookies, T> g) {
        return obj -> g.apply((Cookies)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CookieMatchPattern matchPattern;
        private String matchScope;
        private String oversizeHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(Cookies model) {
            this.matchPattern(model.matchPattern);
            this.matchScope(model.matchScope);
            this.oversizeHandling(model.oversizeHandling);
        }

        public final CookieMatchPattern.Builder getMatchPattern() {
            return this.matchPattern != null ? this.matchPattern.toBuilder() : null;
        }

        public final void setMatchPattern(CookieMatchPattern.BuilderImpl matchPattern) {
            this.matchPattern = matchPattern != null ? matchPattern.build() : null;
        }

        @Override
        public final Builder matchPattern(CookieMatchPattern matchPattern) {
            this.matchPattern = matchPattern;
            return this;
        }

        public final String getMatchScope() {
            return this.matchScope;
        }

        public final void setMatchScope(String matchScope) {
            this.matchScope = matchScope;
        }

        @Override
        public final Builder matchScope(String matchScope) {
            this.matchScope = matchScope;
            return this;
        }

        @Override
        public final Builder matchScope(MapMatchScope matchScope) {
            this.matchScope(matchScope == null ? null : matchScope.toString());
            return this;
        }

        public final String getOversizeHandling() {
            return this.oversizeHandling;
        }

        public final void setOversizeHandling(String oversizeHandling) {
            this.oversizeHandling = oversizeHandling;
        }

        @Override
        public final Builder oversizeHandling(String oversizeHandling) {
            this.oversizeHandling = oversizeHandling;
            return this;
        }

        @Override
        public final Builder oversizeHandling(OversizeHandling oversizeHandling) {
            this.oversizeHandling(oversizeHandling == null ? null : oversizeHandling.toString());
            return this;
        }

        public Cookies build() {
            return new Cookies(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cookies> {
        public Builder matchPattern(CookieMatchPattern var1);

        default public Builder matchPattern(Consumer<CookieMatchPattern.Builder> matchPattern) {
            return this.matchPattern((CookieMatchPattern)((CookieMatchPattern.Builder)CookieMatchPattern.builder().applyMutation(matchPattern)).build());
        }

        public Builder matchScope(String var1);

        public Builder matchScope(MapMatchScope var1);

        public Builder oversizeHandling(String var1);

        public Builder oversizeHandling(OversizeHandling var1);
    }
}

