/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.ResponseInspectionBodyContainsFailureStringsCopier;
import software.amazon.awssdk.services.wafv2.model.ResponseInspectionBodyContainsSuccessStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseInspectionBodyContains
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseInspectionBodyContains> {
    private static final SdkField<List<String>> SUCCESS_STRINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessStrings").getter(ResponseInspectionBodyContains.getter(ResponseInspectionBodyContains::successStrings)).setter(ResponseInspectionBodyContains.setter(Builder::successStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessStrings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FAILURE_STRINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailureStrings").getter(ResponseInspectionBodyContains.getter(ResponseInspectionBodyContains::failureStrings)).setter(ResponseInspectionBodyContains.setter(Builder::failureStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureStrings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESS_STRINGS_FIELD, FAILURE_STRINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResponseInspectionBodyContains.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> successStrings;
    private final List<String> failureStrings;

    private ResponseInspectionBodyContains(BuilderImpl builder) {
        this.successStrings = builder.successStrings;
        this.failureStrings = builder.failureStrings;
    }

    public final boolean hasSuccessStrings() {
        return this.successStrings != null && !(this.successStrings instanceof SdkAutoConstructList);
    }

    public final List<String> successStrings() {
        return this.successStrings;
    }

    public final boolean hasFailureStrings() {
        return this.failureStrings != null && !(this.failureStrings instanceof SdkAutoConstructList);
    }

    public final List<String> failureStrings() {
        return this.failureStrings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessStrings() ? this.successStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureStrings() ? this.failureStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseInspectionBodyContains)) {
            return false;
        }
        ResponseInspectionBodyContains other = (ResponseInspectionBodyContains)obj;
        return this.hasSuccessStrings() == other.hasSuccessStrings() && Objects.equals(this.successStrings(), other.successStrings()) && this.hasFailureStrings() == other.hasFailureStrings() && Objects.equals(this.failureStrings(), other.failureStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseInspectionBodyContains").add("SuccessStrings", this.hasSuccessStrings() ? this.successStrings() : null).add("FailureStrings", this.hasFailureStrings() ? this.failureStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessStrings": {
                return Optional.ofNullable(clazz.cast(this.successStrings()));
            }
            case "FailureStrings": {
                return Optional.ofNullable(clazz.cast(this.failureStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("SuccessStrings", SUCCESS_STRINGS_FIELD);
        map.put("FailureStrings", FAILURE_STRINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponseInspectionBodyContains, T> g) {
        return obj -> g.apply((ResponseInspectionBodyContains)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> successStrings = DefaultSdkAutoConstructList.getInstance();
        private List<String> failureStrings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseInspectionBodyContains model) {
            this.successStrings(model.successStrings);
            this.failureStrings(model.failureStrings);
        }

        public final Collection<String> getSuccessStrings() {
            if (this.successStrings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successStrings;
        }

        public final void setSuccessStrings(Collection<String> successStrings) {
            this.successStrings = ResponseInspectionBodyContainsSuccessStringsCopier.copy(successStrings);
        }

        @Override
        public final Builder successStrings(Collection<String> successStrings) {
            this.successStrings = ResponseInspectionBodyContainsSuccessStringsCopier.copy(successStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successStrings(String ... successStrings) {
            this.successStrings(Arrays.asList(successStrings));
            return this;
        }

        public final Collection<String> getFailureStrings() {
            if (this.failureStrings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureStrings;
        }

        public final void setFailureStrings(Collection<String> failureStrings) {
            this.failureStrings = ResponseInspectionBodyContainsFailureStringsCopier.copy(failureStrings);
        }

        @Override
        public final Builder failureStrings(Collection<String> failureStrings) {
            this.failureStrings = ResponseInspectionBodyContainsFailureStringsCopier.copy(failureStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureStrings(String ... failureStrings) {
            this.failureStrings(Arrays.asList(failureStrings));
            return this;
        }

        public ResponseInspectionBodyContains build() {
            return new ResponseInspectionBodyContains(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseInspectionBodyContains> {
        public Builder successStrings(Collection<String> var1);

        public Builder successStrings(String ... var1);

        public Builder failureStrings(Collection<String> var1);

        public Builder failureStrings(String ... var1);
    }
}

