/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.ResponseInspectionJsonFailureValuesCopier;
import software.amazon.awssdk.services.wafv2.model.ResponseInspectionJsonSuccessValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseInspectionJson
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseInspectionJson> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(ResponseInspectionJson.getter(ResponseInspectionJson::identifier)).setter(ResponseInspectionJson.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<List<String>> SUCCESS_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessValues").getter(ResponseInspectionJson.getter(ResponseInspectionJson::successValues)).setter(ResponseInspectionJson.setter(Builder::successValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FAILURE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailureValues").getter(ResponseInspectionJson.getter(ResponseInspectionJson::failureValues)).setter(ResponseInspectionJson.setter(Builder::failureValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, SUCCESS_VALUES_FIELD, FAILURE_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResponseInspectionJson.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final List<String> successValues;
    private final List<String> failureValues;

    private ResponseInspectionJson(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.successValues = builder.successValues;
        this.failureValues = builder.failureValues;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final boolean hasSuccessValues() {
        return this.successValues != null && !(this.successValues instanceof SdkAutoConstructList);
    }

    public final List<String> successValues() {
        return this.successValues;
    }

    public final boolean hasFailureValues() {
        return this.failureValues != null && !(this.failureValues instanceof SdkAutoConstructList);
    }

    public final List<String> failureValues() {
        return this.failureValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessValues() ? this.successValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureValues() ? this.failureValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseInspectionJson)) {
            return false;
        }
        ResponseInspectionJson other = (ResponseInspectionJson)obj;
        return Objects.equals(this.identifier(), other.identifier()) && this.hasSuccessValues() == other.hasSuccessValues() && Objects.equals(this.successValues(), other.successValues()) && this.hasFailureValues() == other.hasFailureValues() && Objects.equals(this.failureValues(), other.failureValues());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseInspectionJson").add("Identifier", (Object)this.identifier()).add("SuccessValues", this.hasSuccessValues() ? this.successValues() : null).add("FailureValues", this.hasFailureValues() ? this.failureValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "SuccessValues": {
                return Optional.ofNullable(clazz.cast(this.successValues()));
            }
            case "FailureValues": {
                return Optional.ofNullable(clazz.cast(this.failureValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("SuccessValues", SUCCESS_VALUES_FIELD);
        map.put("FailureValues", FAILURE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponseInspectionJson, T> g) {
        return obj -> g.apply((ResponseInspectionJson)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private List<String> successValues = DefaultSdkAutoConstructList.getInstance();
        private List<String> failureValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseInspectionJson model) {
            this.identifier(model.identifier);
            this.successValues(model.successValues);
            this.failureValues(model.failureValues);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Collection<String> getSuccessValues() {
            if (this.successValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successValues;
        }

        public final void setSuccessValues(Collection<String> successValues) {
            this.successValues = ResponseInspectionJsonSuccessValuesCopier.copy(successValues);
        }

        @Override
        public final Builder successValues(Collection<String> successValues) {
            this.successValues = ResponseInspectionJsonSuccessValuesCopier.copy(successValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successValues(String ... successValues) {
            this.successValues(Arrays.asList(successValues));
            return this;
        }

        public final Collection<String> getFailureValues() {
            if (this.failureValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureValues;
        }

        public final void setFailureValues(Collection<String> failureValues) {
            this.failureValues = ResponseInspectionJsonFailureValuesCopier.copy(failureValues);
        }

        @Override
        public final Builder failureValues(Collection<String> failureValues) {
            this.failureValues = ResponseInspectionJsonFailureValuesCopier.copy(failureValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureValues(String ... failureValues) {
            this.failureValues(Arrays.asList(failureValues));
            return this;
        }

        public ResponseInspectionJson build() {
            return new ResponseInspectionJson(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseInspectionJson> {
        public Builder identifier(String var1);

        public Builder successValues(Collection<String> var1);

        public Builder successValues(String ... var1);

        public Builder failureValues(Collection<String> var1);

        public Builder failureValues(String ... var1);
    }
}

