/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wafv2.model.RateLimitCookie;
import software.amazon.awssdk.services.wafv2.model.RateLimitForwardedIP;
import software.amazon.awssdk.services.wafv2.model.RateLimitHTTPMethod;
import software.amazon.awssdk.services.wafv2.model.RateLimitHeader;
import software.amazon.awssdk.services.wafv2.model.RateLimitIP;
import software.amazon.awssdk.services.wafv2.model.RateLimitLabelNamespace;
import software.amazon.awssdk.services.wafv2.model.RateLimitQueryArgument;
import software.amazon.awssdk.services.wafv2.model.RateLimitQueryString;
import software.amazon.awssdk.services.wafv2.model.RateLimitUriPath;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RateBasedStatementCustomKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RateBasedStatementCustomKey> {
    private static final SdkField<RateLimitHeader> HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Header").getter(RateBasedStatementCustomKey.getter(RateBasedStatementCustomKey::header)).setter(RateBasedStatementCustomKey.setter(Builder::header)).constructor(RateLimitHeader::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header").build()}).build();
    private static final SdkField<RateLimitCookie> COOKIE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Cookie").getter(RateBasedStatementCustomKey.getter(RateBasedStatementCustomKey::cookie)).setter(RateBasedStatementCustomKey.setter(Builder::cookie)).constructor(RateLimitCookie::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cookie").build()}).build();
    private static final SdkField<RateLimitQueryArgument> QUERY_ARGUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryArgument").getter(RateBasedStatementCustomKey.getter(RateBasedStatementCustomKey::queryArgument)).setter(RateBasedStatementCustomKey.setter(Builder::queryArgument)).constructor(RateLimitQueryArgument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryArgument").build()}).build();
    private static final SdkField<RateLimitQueryString> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryString").getter(RateBasedStatementCustomKey.getter(RateBasedStatementCustomKey::queryString)).setter(RateBasedStatementCustomKey.setter(Builder::queryString)).constructor(RateLimitQueryString::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()}).build();
    private static final SdkField<RateLimitHTTPMethod> HTTP_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HTTPMethod").getter(RateBasedStatementCustomKey.getter(RateBasedStatementCustomKey::httpMethod)).setter(RateBasedStatementCustomKey.setter(Builder::httpMethod)).constructor(RateLimitHTTPMethod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPMethod").build()}).build();
    private static final SdkField<RateLimitForwardedIP> FORWARDED_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForwardedIP").getter(RateBasedStatementCustomKey.getter(RateBasedStatementCustomKey::forwardedIP)).setter(RateBasedStatementCustomKey.setter(Builder::forwardedIP)).constructor(RateLimitForwardedIP::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardedIP").build()}).build();
    private static final SdkField<RateLimitIP> IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IP").getter(RateBasedStatementCustomKey.getter(RateBasedStatementCustomKey::ip)).setter(RateBasedStatementCustomKey.setter(Builder::ip)).constructor(RateLimitIP::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IP").build()}).build();
    private static final SdkField<RateLimitLabelNamespace> LABEL_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelNamespace").getter(RateBasedStatementCustomKey.getter(RateBasedStatementCustomKey::labelNamespace)).setter(RateBasedStatementCustomKey.setter(Builder::labelNamespace)).constructor(RateLimitLabelNamespace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelNamespace").build()}).build();
    private static final SdkField<RateLimitUriPath> URI_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UriPath").getter(RateBasedStatementCustomKey.getter(RateBasedStatementCustomKey::uriPath)).setter(RateBasedStatementCustomKey.setter(Builder::uriPath)).constructor(RateLimitUriPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UriPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_FIELD, COOKIE_FIELD, QUERY_ARGUMENT_FIELD, QUERY_STRING_FIELD, HTTP_METHOD_FIELD, FORWARDED_IP_FIELD, IP_FIELD, LABEL_NAMESPACE_FIELD, URI_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Header", HEADER_FIELD);
            this.put("Cookie", COOKIE_FIELD);
            this.put("QueryArgument", QUERY_ARGUMENT_FIELD);
            this.put("QueryString", QUERY_STRING_FIELD);
            this.put("HTTPMethod", HTTP_METHOD_FIELD);
            this.put("ForwardedIP", FORWARDED_IP_FIELD);
            this.put("IP", IP_FIELD);
            this.put("LabelNamespace", LABEL_NAMESPACE_FIELD);
            this.put("UriPath", URI_PATH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final RateLimitHeader header;
    private final RateLimitCookie cookie;
    private final RateLimitQueryArgument queryArgument;
    private final RateLimitQueryString queryString;
    private final RateLimitHTTPMethod httpMethod;
    private final RateLimitForwardedIP forwardedIP;
    private final RateLimitIP ip;
    private final RateLimitLabelNamespace labelNamespace;
    private final RateLimitUriPath uriPath;

    private RateBasedStatementCustomKey(BuilderImpl builder) {
        this.header = builder.header;
        this.cookie = builder.cookie;
        this.queryArgument = builder.queryArgument;
        this.queryString = builder.queryString;
        this.httpMethod = builder.httpMethod;
        this.forwardedIP = builder.forwardedIP;
        this.ip = builder.ip;
        this.labelNamespace = builder.labelNamespace;
        this.uriPath = builder.uriPath;
    }

    public final RateLimitHeader header() {
        return this.header;
    }

    public final RateLimitCookie cookie() {
        return this.cookie;
    }

    public final RateLimitQueryArgument queryArgument() {
        return this.queryArgument;
    }

    public final RateLimitQueryString queryString() {
        return this.queryString;
    }

    public final RateLimitHTTPMethod httpMethod() {
        return this.httpMethod;
    }

    public final RateLimitForwardedIP forwardedIP() {
        return this.forwardedIP;
    }

    public final RateLimitIP ip() {
        return this.ip;
    }

    public final RateLimitLabelNamespace labelNamespace() {
        return this.labelNamespace;
    }

    public final RateLimitUriPath uriPath() {
        return this.uriPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.header());
        hashCode = 31 * hashCode + Objects.hashCode(this.cookie());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryArgument());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardedIP());
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.uriPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RateBasedStatementCustomKey)) {
            return false;
        }
        RateBasedStatementCustomKey other = (RateBasedStatementCustomKey)obj;
        return Objects.equals(this.header(), other.header()) && Objects.equals(this.cookie(), other.cookie()) && Objects.equals(this.queryArgument(), other.queryArgument()) && Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.httpMethod(), other.httpMethod()) && Objects.equals(this.forwardedIP(), other.forwardedIP()) && Objects.equals(this.ip(), other.ip()) && Objects.equals(this.labelNamespace(), other.labelNamespace()) && Objects.equals(this.uriPath(), other.uriPath());
    }

    public final String toString() {
        return ToString.builder((String)"RateBasedStatementCustomKey").add("Header", (Object)this.header()).add("Cookie", (Object)this.cookie()).add("QueryArgument", (Object)this.queryArgument()).add("QueryString", (Object)this.queryString()).add("HTTPMethod", (Object)this.httpMethod()).add("ForwardedIP", (Object)this.forwardedIP()).add("IP", (Object)this.ip()).add("LabelNamespace", (Object)this.labelNamespace()).add("UriPath", (Object)this.uriPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Header": {
                return Optional.ofNullable(clazz.cast(this.header()));
            }
            case "Cookie": {
                return Optional.ofNullable(clazz.cast(this.cookie()));
            }
            case "QueryArgument": {
                return Optional.ofNullable(clazz.cast(this.queryArgument()));
            }
            case "QueryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
            case "HTTPMethod": {
                return Optional.ofNullable(clazz.cast(this.httpMethod()));
            }
            case "ForwardedIP": {
                return Optional.ofNullable(clazz.cast(this.forwardedIP()));
            }
            case "IP": {
                return Optional.ofNullable(clazz.cast(this.ip()));
            }
            case "LabelNamespace": {
                return Optional.ofNullable(clazz.cast(this.labelNamespace()));
            }
            case "UriPath": {
                return Optional.ofNullable(clazz.cast(this.uriPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RateBasedStatementCustomKey, T> g) {
        return obj -> g.apply((RateBasedStatementCustomKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RateLimitHeader header;
        private RateLimitCookie cookie;
        private RateLimitQueryArgument queryArgument;
        private RateLimitQueryString queryString;
        private RateLimitHTTPMethod httpMethod;
        private RateLimitForwardedIP forwardedIP;
        private RateLimitIP ip;
        private RateLimitLabelNamespace labelNamespace;
        private RateLimitUriPath uriPath;

        private BuilderImpl() {
        }

        private BuilderImpl(RateBasedStatementCustomKey model) {
            this.header(model.header);
            this.cookie(model.cookie);
            this.queryArgument(model.queryArgument);
            this.queryString(model.queryString);
            this.httpMethod(model.httpMethod);
            this.forwardedIP(model.forwardedIP);
            this.ip(model.ip);
            this.labelNamespace(model.labelNamespace);
            this.uriPath(model.uriPath);
        }

        public final RateLimitHeader.Builder getHeader() {
            return this.header != null ? this.header.toBuilder() : null;
        }

        public final void setHeader(RateLimitHeader.BuilderImpl header) {
            this.header = header != null ? header.build() : null;
        }

        @Override
        public final Builder header(RateLimitHeader header) {
            this.header = header;
            return this;
        }

        public final RateLimitCookie.Builder getCookie() {
            return this.cookie != null ? this.cookie.toBuilder() : null;
        }

        public final void setCookie(RateLimitCookie.BuilderImpl cookie) {
            this.cookie = cookie != null ? cookie.build() : null;
        }

        @Override
        public final Builder cookie(RateLimitCookie cookie) {
            this.cookie = cookie;
            return this;
        }

        public final RateLimitQueryArgument.Builder getQueryArgument() {
            return this.queryArgument != null ? this.queryArgument.toBuilder() : null;
        }

        public final void setQueryArgument(RateLimitQueryArgument.BuilderImpl queryArgument) {
            this.queryArgument = queryArgument != null ? queryArgument.build() : null;
        }

        @Override
        public final Builder queryArgument(RateLimitQueryArgument queryArgument) {
            this.queryArgument = queryArgument;
            return this;
        }

        public final RateLimitQueryString.Builder getQueryString() {
            return this.queryString != null ? this.queryString.toBuilder() : null;
        }

        public final void setQueryString(RateLimitQueryString.BuilderImpl queryString) {
            this.queryString = queryString != null ? queryString.build() : null;
        }

        @Override
        public final Builder queryString(RateLimitQueryString queryString) {
            this.queryString = queryString;
            return this;
        }

        public final RateLimitHTTPMethod.Builder getHttpMethod() {
            return this.httpMethod != null ? this.httpMethod.toBuilder() : null;
        }

        public final void setHttpMethod(RateLimitHTTPMethod.BuilderImpl httpMethod) {
            this.httpMethod = httpMethod != null ? httpMethod.build() : null;
        }

        @Override
        public final Builder httpMethod(RateLimitHTTPMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final RateLimitForwardedIP.Builder getForwardedIP() {
            return this.forwardedIP != null ? this.forwardedIP.toBuilder() : null;
        }

        public final void setForwardedIP(RateLimitForwardedIP.BuilderImpl forwardedIP) {
            this.forwardedIP = forwardedIP != null ? forwardedIP.build() : null;
        }

        @Override
        public final Builder forwardedIP(RateLimitForwardedIP forwardedIP) {
            this.forwardedIP = forwardedIP;
            return this;
        }

        public final RateLimitIP.Builder getIp() {
            return this.ip != null ? this.ip.toBuilder() : null;
        }

        public final void setIp(RateLimitIP.BuilderImpl ip) {
            this.ip = ip != null ? ip.build() : null;
        }

        @Override
        public final Builder ip(RateLimitIP ip) {
            this.ip = ip;
            return this;
        }

        public final RateLimitLabelNamespace.Builder getLabelNamespace() {
            return this.labelNamespace != null ? this.labelNamespace.toBuilder() : null;
        }

        public final void setLabelNamespace(RateLimitLabelNamespace.BuilderImpl labelNamespace) {
            this.labelNamespace = labelNamespace != null ? labelNamespace.build() : null;
        }

        @Override
        public final Builder labelNamespace(RateLimitLabelNamespace labelNamespace) {
            this.labelNamespace = labelNamespace;
            return this;
        }

        public final RateLimitUriPath.Builder getUriPath() {
            return this.uriPath != null ? this.uriPath.toBuilder() : null;
        }

        public final void setUriPath(RateLimitUriPath.BuilderImpl uriPath) {
            this.uriPath = uriPath != null ? uriPath.build() : null;
        }

        @Override
        public final Builder uriPath(RateLimitUriPath uriPath) {
            this.uriPath = uriPath;
            return this;
        }

        public RateBasedStatementCustomKey build() {
            return new RateBasedStatementCustomKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RateBasedStatementCustomKey> {
        public Builder header(RateLimitHeader var1);

        default public Builder header(Consumer<RateLimitHeader.Builder> header) {
            return this.header((RateLimitHeader)((RateLimitHeader.Builder)RateLimitHeader.builder().applyMutation(header)).build());
        }

        public Builder cookie(RateLimitCookie var1);

        default public Builder cookie(Consumer<RateLimitCookie.Builder> cookie) {
            return this.cookie((RateLimitCookie)((RateLimitCookie.Builder)RateLimitCookie.builder().applyMutation(cookie)).build());
        }

        public Builder queryArgument(RateLimitQueryArgument var1);

        default public Builder queryArgument(Consumer<RateLimitQueryArgument.Builder> queryArgument) {
            return this.queryArgument((RateLimitQueryArgument)((RateLimitQueryArgument.Builder)RateLimitQueryArgument.builder().applyMutation(queryArgument)).build());
        }

        public Builder queryString(RateLimitQueryString var1);

        default public Builder queryString(Consumer<RateLimitQueryString.Builder> queryString) {
            return this.queryString((RateLimitQueryString)((RateLimitQueryString.Builder)RateLimitQueryString.builder().applyMutation(queryString)).build());
        }

        public Builder httpMethod(RateLimitHTTPMethod var1);

        default public Builder httpMethod(Consumer<RateLimitHTTPMethod.Builder> httpMethod) {
            return this.httpMethod((RateLimitHTTPMethod)((RateLimitHTTPMethod.Builder)RateLimitHTTPMethod.builder().applyMutation(httpMethod)).build());
        }

        public Builder forwardedIP(RateLimitForwardedIP var1);

        default public Builder forwardedIP(Consumer<RateLimitForwardedIP.Builder> forwardedIP) {
            return this.forwardedIP((RateLimitForwardedIP)((RateLimitForwardedIP.Builder)RateLimitForwardedIP.builder().applyMutation(forwardedIP)).build());
        }

        public Builder ip(RateLimitIP var1);

        default public Builder ip(Consumer<RateLimitIP.Builder> ip) {
            return this.ip((RateLimitIP)((RateLimitIP.Builder)RateLimitIP.builder().applyMutation(ip)).build());
        }

        public Builder labelNamespace(RateLimitLabelNamespace var1);

        default public Builder labelNamespace(Consumer<RateLimitLabelNamespace.Builder> labelNamespace) {
            return this.labelNamespace((RateLimitLabelNamespace)((RateLimitLabelNamespace.Builder)RateLimitLabelNamespace.builder().applyMutation(labelNamespace)).build());
        }

        public Builder uriPath(RateLimitUriPath var1);

        default public Builder uriPath(Consumer<RateLimitUriPath.Builder> uriPath) {
            return this.uriPath((RateLimitUriPath)((RateLimitUriPath.Builder)RateLimitUriPath.builder().applyMutation(uriPath)).build());
        }
    }
}

