/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.wafv2.DefaultWafv2BaseClientBuilder;
import software.amazon.awssdk.services.wafv2.DefaultWafv2Client;
import software.amazon.awssdk.services.wafv2.Wafv2Client;
import software.amazon.awssdk.services.wafv2.Wafv2ClientBuilder;
import software.amazon.awssdk.services.wafv2.Wafv2ServiceClientConfiguration;
import software.amazon.awssdk.services.wafv2.endpoints.Wafv2EndpointProvider;

@SdkInternalApi
final class DefaultWafv2ClientBuilder
extends DefaultWafv2BaseClientBuilder<Wafv2ClientBuilder, Wafv2Client>
implements Wafv2ClientBuilder {
    DefaultWafv2ClientBuilder() {
    }

    @Override
    public DefaultWafv2ClientBuilder endpointProvider(Wafv2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final Wafv2Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWafv2ClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        Wafv2ServiceClientConfiguration serviceClientConfiguration = Wafv2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultWafv2Client(serviceClientConfiguration, clientConfiguration);
    }
}

