/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wafv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wafv2.model.All;
import software.amazon.awssdk.services.wafv2.model.CookieNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CookieMatchPattern
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CookieMatchPattern> {
    private static final SdkField<All> ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("All").getter(CookieMatchPattern.getter(CookieMatchPattern::all)).setter(CookieMatchPattern.setter(Builder::all)).constructor(All::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("All").build()}).build();
    private static final SdkField<List<String>> INCLUDED_COOKIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedCookies").getter(CookieMatchPattern.getter(CookieMatchPattern::includedCookies)).setter(CookieMatchPattern.setter(Builder::includedCookies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedCookies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDED_COOKIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedCookies").getter(CookieMatchPattern.getter(CookieMatchPattern::excludedCookies)).setter(CookieMatchPattern.setter(Builder::excludedCookies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedCookies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_FIELD, INCLUDED_COOKIES_FIELD, EXCLUDED_COOKIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final All all;
    private final List<String> includedCookies;
    private final List<String> excludedCookies;

    private CookieMatchPattern(BuilderImpl builder) {
        this.all = builder.all;
        this.includedCookies = builder.includedCookies;
        this.excludedCookies = builder.excludedCookies;
    }

    public final All all() {
        return this.all;
    }

    public final boolean hasIncludedCookies() {
        return this.includedCookies != null && !(this.includedCookies instanceof SdkAutoConstructList);
    }

    public final List<String> includedCookies() {
        return this.includedCookies;
    }

    public final boolean hasExcludedCookies() {
        return this.excludedCookies != null && !(this.excludedCookies instanceof SdkAutoConstructList);
    }

    public final List<String> excludedCookies() {
        return this.excludedCookies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.all());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedCookies() ? this.includedCookies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedCookies() ? this.excludedCookies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookieMatchPattern)) {
            return false;
        }
        CookieMatchPattern other = (CookieMatchPattern)obj;
        return Objects.equals(this.all(), other.all()) && this.hasIncludedCookies() == other.hasIncludedCookies() && Objects.equals(this.includedCookies(), other.includedCookies()) && this.hasExcludedCookies() == other.hasExcludedCookies() && Objects.equals(this.excludedCookies(), other.excludedCookies());
    }

    public final String toString() {
        return ToString.builder((String)"CookieMatchPattern").add("All", (Object)this.all()).add("IncludedCookies", this.hasIncludedCookies() ? this.includedCookies() : null).add("ExcludedCookies", this.hasExcludedCookies() ? this.excludedCookies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "All": {
                return Optional.ofNullable(clazz.cast(this.all()));
            }
            case "IncludedCookies": {
                return Optional.ofNullable(clazz.cast(this.includedCookies()));
            }
            case "ExcludedCookies": {
                return Optional.ofNullable(clazz.cast(this.excludedCookies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CookieMatchPattern, T> g) {
        return obj -> g.apply((CookieMatchPattern)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private All all;
        private List<String> includedCookies = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludedCookies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CookieMatchPattern model) {
            this.all(model.all);
            this.includedCookies(model.includedCookies);
            this.excludedCookies(model.excludedCookies);
        }

        public final All.Builder getAll() {
            return this.all != null ? this.all.toBuilder() : null;
        }

        public final void setAll(All.BuilderImpl all) {
            this.all = all != null ? all.build() : null;
        }

        @Override
        public final Builder all(All all) {
            this.all = all;
            return this;
        }

        public final Collection<String> getIncludedCookies() {
            if (this.includedCookies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includedCookies;
        }

        public final void setIncludedCookies(Collection<String> includedCookies) {
            this.includedCookies = CookieNamesCopier.copy(includedCookies);
        }

        @Override
        public final Builder includedCookies(Collection<String> includedCookies) {
            this.includedCookies = CookieNamesCopier.copy(includedCookies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedCookies(String ... includedCookies) {
            this.includedCookies(Arrays.asList(includedCookies));
            return this;
        }

        public final Collection<String> getExcludedCookies() {
            if (this.excludedCookies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedCookies;
        }

        public final void setExcludedCookies(Collection<String> excludedCookies) {
            this.excludedCookies = CookieNamesCopier.copy(excludedCookies);
        }

        @Override
        public final Builder excludedCookies(Collection<String> excludedCookies) {
            this.excludedCookies = CookieNamesCopier.copy(excludedCookies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedCookies(String ... excludedCookies) {
            this.excludedCookies(Arrays.asList(excludedCookies));
            return this;
        }

        public CookieMatchPattern build() {
            return new CookieMatchPattern(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CookieMatchPattern> {
        public Builder all(All var1);

        default public Builder all(Consumer<All.Builder> all) {
            return this.all((All)((All.Builder)All.builder().applyMutation(all)).build());
        }

        public Builder includedCookies(Collection<String> var1);

        public Builder includedCookies(String ... var1);

        public Builder excludedCookies(Collection<String> var1);

        public Builder excludedCookies(String ... var1);
    }
}

